/*
 * swmod_crun.h: SWMOD CRUN handler
 *
 * Copyright (C) 2020-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 */

#ifndef SWMOD_CRUN_H
#define SWMOD_CRUN_H

#include "swmod_common.h"

int swmod_crun_perform_install(const PkgInfo *pkg, char *output, int out_len);
int swmod_crun_perform_remove(const char *ct_name, char *output, int outlen);
void populate_crun_eu(ExecEnv_t *ee, const char *oci_uci_path);
int swmod_set_crun_service_state(ExecEnv_t *ee, char *eu, bool state, const char *oci_uci_path);
void swmod_perform_crun_install(char *section, int len);
void read_fault_code(struct ubus_request *req, int type, struct blob_attr *msg);

#endif // SWMOD_CRUN_H
