/*
 * swmod.h: SWMOD deamon
 *
 * Copyright (C) 2020-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Amin Ben Ramdhane <amin.benramdhane@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 */

#ifndef SWMOD_H
#define SWMOD_H

#include <stdbool.h>
#include <libubox/blobmsg.h>
#include <libubox/blobmsg_json.h>
#include <libubus.h>

#include "swmod_common.h"

#define BBFDM_OBJECT_NAME "bbfdm"
#define HOST_SYSTEM "OpenWRT_Linux"
#define MAX_ENV 8 //Max Environment
#define MAX_EU 256 //Max Execution Unit
#define UBUS_TIMEOUT 5000 // 5 seconds
#define MAX_BUFFER_LEN (102400)
#define MAX_LEN_16 16
#define MAX_LEN_32 32
#define MAX_LEN_64 64
#define MAX_LEN_65 65
#define MAX_LEN_128 128
#define MAX_LEN_256 256
#define MAX_LEN_512 512
#define MAX_LEN_1024 1024

typedef enum {
	EE_TYPE_UNKNOWN,
	EE_TYPE_HOST,
	EE_TYPE_LXC,
	EE_TYPE_CRUN,
	EE_TYPE_MAX
} EE_TYPE_t;

typedef struct {
	bool exists;
	unsigned int parent_eeid;
	unsigned int eeid;
	EE_TYPE_t ee_type;
	int pause;
	int autoboot;
	unsigned long allocated_disk_space; //AllocatedDiskSpace
	unsigned long available_disk_space; //AvailableDiskSpace
	unsigned long allocated_memory; //AllocatedMemory
	unsigned long available_memory; //AvailableMemory
	struct list_head eu_list;
	char status[MAX_LEN_32]; //Status
	char name[MAX_LEN_32]; //Name
	char type[MAX_LEN_64]; //Type
	char vendor[MAX_LEN_128]; //Vendor
	char version[MAX_LEN_16]; //Version
	char alias[MAX_LEN_65]; //Version
} ExecEnv_t;

typedef struct ExecUnit {
	bool eu_exists;
	bool autostart;
	int disk_space; //DiskSpaceInUse
	int memory_space; //MemoryInUse
	char euid[MAX_LEN_65]; //EUID
	char name[MAX_LEN_32]; // //Execution Unit Name
	char state[MAX_LEN_32]; // //Execution Unit Name
	char command[MAX_LEN_32]; //Execution Unit Command
	char vendor[MAX_LEN_128]; //Execution Unit Vendor
	char config[MAX_LEN_32]; //Config File
	char version[MAX_LEN_32]; //Version
	char description[MAX_LEN_1024]; //Description
	char environment[MAX_LEN_32]; //Environment Name
	char req_state[MAX_LEN_16];
	char du_name[MAX_LEN_64]; // //Deployment Unit Name
	char eu_alias[MAX_LEN_65];
	char fault_code[MAX_LEN_32];
} ExecUnit;

typedef struct EuNode {
	ExecUnit eu;
	struct list_head list;
} EuNode;

typedef struct ExecEnvNode {
	ExecEnv_t env;
	struct list_head list;
} ExecEnvNode;

typedef struct swmodConfig {
	char oci_bundle_root[MAX_LEN_64];
	char lxc_bundle_root[MAX_LEN_64];
} ConfigParams;

struct du_info {
	char du_type[MAX_LEN_16];
	char name[MAX_LEN_64];
	char version[MAX_LEN_64];
	char desc[256];
	char eu_name[33];
};

extern struct ubus_context *ubus_ctx;
extern ExecEnv_t g_environments[MAX_ENV];
extern ConfigParams swmod_config;

void swmod_send_event_du_state_change(bool failed, int code, time_t start, time_t end,
			const char *uuid, const char *ver, int action, const char *err,
			unsigned long instance);
ExecEnv_t* get_ee_from_name(char *ename);
ExecEnv_t* get_ee_from_eeid(unsigned int eid);
#endif //SWMOD_H
