#!/bin/bash

function cleanup()
{
	echo ""
}

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function check_memory_leak()
{
	memory_log=${1}

	if [ ! -f ${memory_log} ]; then
		echo "Memory log ${memory_log} not present for validation"
		exit 1;
	fi

	echo "Checking memory leaks..."
	grep -q "UninitCondition" ${memory_log}
	error_on_zero $?

	grep -q "Leak_DefinitelyLost" ${memory_log}
	error_on_zero $?

	grep -q "Leak_PossiblyLost" ${memory_log}
	error_on_zero $?

	grep -q "Leak_StillReachable" ${memory_log}
	error_on_zero $?
}

function build_swmodd()
{
	SWMOD_LXC=yes CFLAGS="-g -O0 -fprofile-arcs -ftest-coverage" LDFLAGS="--coverage" make
	check_ret $?
	mkdir -p /usr/lib/bbfdm/
	exec_cmd cp -f libswmodd.so /usr/lib/bbfdm/libswmodd.so
	exec_cmd ln -s ${PWD}/swmodd /usr/sbin/swmodd
}

function install_bbfdm()
{
	[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	./gitlab-ci/install-dependencies.sh install
	./gitlab-ci/setup.sh install
}
