#!/bin/bash

echo "$0 preparation script"
pwd

source ./gitlab-ci/shared.sh

trap cleanup EXIT
trap cleanup SIGINT

date +%s > timestamp.log
# clean and make
make clean
build_swmodd

supervisorctl update
supervisorctl restart all
sleep 5
supervisorctl status all
exec_cmd ubus wait_for bbfdm swmodules

echo "Running API test"
mkdir -p /usr/share/rpcd/schemas/
exec_cmd cp -f ./schemas/ubus/swmodules.json /usr/share/rpcd/schemas/
ubus-api-validator -f ./test/api/json/swmodules.validation.json > ./api-result.log
check_ret $?

supervisorctl status all
supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./api-test-coverage.xml
gcovr -r .
exec_cmd tap-junit --input ./api-result.log --output report
check_memory_leak /tmp/memory-report.xml

echo "Functional ubus API test :: PASS"
