# How to create a OCI application container from source code

It is often required to compile the application from source before embedding it in an application container.

This example usages docker multi-pass build to build the app from source and also at the same time minimize the final docker image size.

Here in this example, `./src` directory has the source code for the example application
```
src/
├── hello.c
└── Makefile
```

Along with the example application source code,

```
├── config.json
├── Dockerfile.alpine
├── Dockerfile.ubuntu
├── Makefile
```

It also has a Makefile to simplify/automate the build process and two different Dockerfile to build this application in two different base images based on

- Dockerfile.alpine => alpine base image
- Dockerfile.ubuntu => ubuntu base image

> Note: config.json is just an example config, its requested to modify the config.json specially the mount paths based on app container requirement.

## Build the example

To build the example, user need to select the

- Base image (default is alpine)
  - `export BASE=alpine`
- Target Platform (default is linux/arm64/v8)
  - `export PLATFORM=linux/arm64/v8`

> Note: sudo permission is used in the Makefile to fix the container ownership

To build the application container run below command
```
$ make
```

To build with non-default platform/base
```
$ PLATFORM=linux/arm/v5 BASE=ubuntu make
```

If build is successful, it will result into a `iowrt.tar` file, which can be install in cpe using tr181
```
$ obuspa -c operate "Device.SoftwareModules.InstallDU(URL=file:///tmp/iowrt.tar)"
```

> Note: Assuming tar file copied to CPE in /tmp

Once successfully installed container status can be checked with
```
1. TR181
  - `obuspa -c get Device.SoftwareModules.ExecutionUnit.`
2. By using CRUN native commands
  - `crun list`

To manage/debug the container, crun native can be used, like
- `crun exec -t iowrt sh`

> Note: This is just an example, iowrt SMM does not require all these application installed-in, 3rd party integrator requested to follow the example and to create/build their own dependency chain as required.
