# swmodules Schema

```
https://dev.iopsys.eu/iopsys/swmodd/schemas/ubus/swmodules.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Forbidden             |

# swmodules

| List of Methods               |
| ----------------------------- |
| [du_install](#du_install)     | Method | swmodules (this schema) |
| [du_list](#du_list)           | Method | swmodules (this schema) |
| [du_uninstall](#du_uninstall) | Method | swmodules (this schema) |
| [du_update](#du_update)       | Method | swmodules (this schema) |
| [ee_list](#ee_list)           | Method | swmodules (this schema) |
| [ee_set_state](#ee_set_state) | Method | swmodules (this schema) |
| [eu_list](#eu_list)           | Method | swmodules (this schema) |
| [eu_set_state](#eu_set_state) | Method | swmodules (this schema) |

## du_install

### Install new deployment units/packages into Execution environment

`du_install`

- type: `Method`

### du_install Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property   | Type    | Required     |
| ---------- | ------- | ------------ |
| `ee_name`  | string  | Optional     |
| `eeid`     | integer | Optional     |
| `password` | string  | Optional     |
| `url`      | string  | **Required** |
| `username` | string  | Optional     |
| `uuid`     | string  | Optional     |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

#### password

`password`

- is optional
- type: `string`

##### password Type

`string`

#### url

`url`

- is **required**
- type: `string`

##### url Type

`string`

#### username

`username`

- is optional
- type: `string`

##### username Type

`string`

#### uuid

`uuid`

- is optional
- type: `string`

##### uuid Type

`string`

### Ubus CLI Example

```
ubus call swmodules du_install {"url":"mollit deserunt","uuid":"nulla aliquip eu","username":"amet exe","password":"velit voluptate enim ad in","ee_name":"sed quis","eeid":4}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": [
    "<SID>",
    "swmodules",
    "du_install",
    {
      "url": "mollit deserunt",
      "uuid": "nulla aliquip eu",
      "username": "amet exe",
      "password": "velit voluptate enim ad in",
      "ee_name": "sed quis",
      "eeid": 4
    }
  ]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `status` | boolean | **Required** |

#### status

`status`

- is **required**
- type: `boolean`

##### status Type

`boolean`

### Output Example

```json
{ "status": false }
```

## du_list

### Get list of deployment units (installed packages)

`du_list`

- type: `Method`

### du_list Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` |        | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type    | Required |
| --------- | ------- | -------- |
| `ee_name` | string  | Optional |
| `eeid`    | integer | Optional |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

### Ubus CLI Example

```
ubus call swmodules du_list {"eeid":6,"ee_name":"quis exercitation nisi ullamco"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "swmodules", "du_list", { "eeid": 6, "ee_name": "quis exercitation nisi ullamco" }]
}
```

#### output

`output`

- is optional
- type: complex

##### output Type

Unknown type ``.

```json
{
  "oneof": [
    {
      "type": "object",
      "properties": {
        "deployment_unit": {
          "type": "array",
          "items": [
            {
              "type": "object",
              "properties": {
                "du_name": {
                  "type": "string"
                },
                "ee_name": {
                  "type": "string"
                },
                "eeid": {
                  "type": "integer",
                  "minimum": 1
                },
                "uuid": {
                  "type": "string"
                },
                "duid": {
                  "type": "string"
                },
                "url": {
                  "type": "string"
                },
                "version": {
                  "type": "string"
                },
                "config": {
                  "type": "string"
                },
                "description": {
                  "type": "string"
                },
                "vendor": {
                  "type": "string"
                }
              },
              "required": ["du_name", "ee_name", "eeid", "uuid", "duid", "url", "version", "config", "description", "vendor"]
            }
          ]
        }
      }
    },
    {
      "type": "object",
      "properties": {
        "deployment_unit": {
          "type": "array",
          "items": []
        }
      }
    }
  ],
  "out": "{\"oneof\":[{\"deployment_unit\":[{\"du_name\":\"ea\",\"ee_name\":\"ullamco pariatur tempor\",\"uuid\":\"nostrud minim\",\"duid\":\"dolor in deserunt velit\",\"url\":\"Excepteur consequat\",\"version\":\"ut in nostrud nulla aliqu\",\"config\":\"qui\",\"description\":\"cillum ea incididunt pa\",\"vendor\":\"sed dolor\",\"eeid\":6}]},{\"deployment_unit\":[]}]}",
  "simpletype": "complex"
}
```

### Output Example

```json
{
  "oneof": [
    {
      "deployment_unit": [
        {
          "du_name": "ea",
          "ee_name": "ullamco pariatur tempor",
          "uuid": "nostrud minim",
          "duid": "dolor in deserunt velit",
          "url": "Excepteur consequat",
          "version": "ut in nostrud nulla aliqu",
          "config": "qui",
          "description": "cillum ea incididunt pa",
          "vendor": "sed dolor",
          "eeid": 6
        }
      ]
    },
    { "deployment_unit": [] }
  ]
}
```

## du_uninstall

### Uninstall installed deployment units/packages

`du_uninstall`

- type: `Method`

### du_uninstall Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type    | Required     |
| --------- | ------- | ------------ |
| `du_name` | string  | **Required** |
| `ee_name` | string  | Optional     |
| `eeid`    | integer | Optional     |

#### du_name

`du_name`

- is **required**
- type: `string`

##### du_name Type

`string`

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

### Ubus CLI Example

```
ubus call swmodules du_uninstall {"du_name":"est eiusmod culpa commodo","ee_name":"dolor ad","eeid":8}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": [
    "<SID>",
    "swmodules",
    "du_uninstall",
    { "du_name": "est eiusmod culpa commodo", "ee_name": "dolor ad", "eeid": 8 }
  ]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required |
| -------- | ------- | -------- |
| `status` | boolean | Optional |

#### status

`status`

- is optional
- type: `boolean`

##### status Type

`boolean`

### Output Example

```json
{ "status": true }
```

## du_update

### Update already installed deployment units

`du_update`

- type: `Method`

### du_update Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property   | Type    | Required     |
| ---------- | ------- | ------------ |
| `ee_name`  | string  | Optional     |
| `eeid`     | integer | Optional     |
| `password` | string  | Optional     |
| `url`      | string  | **Required** |
| `username` | string  | Optional     |
| `uuid`     | string  | **Required** |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

#### password

`password`

- is optional
- type: `string`

##### password Type

`string`

#### url

`url`

- is **required**
- type: `string`

##### url Type

`string`

#### username

`username`

- is optional
- type: `string`

##### username Type

`string`

#### uuid

`uuid`

- is **required**
- type: `string`

##### uuid Type

`string`

### Ubus CLI Example

```
ubus call swmodules du_update {"url":"officia dolore eiusmod","uuid":"dolor sint","eeid":4,"ee_name":"sit amet ad","username":"aliqua non sit dolore sint","password":"Lorem in ut Duis"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": [
    "<SID>",
    "swmodules",
    "du_update",
    {
      "url": "officia dolore eiusmod",
      "uuid": "dolor sint",
      "eeid": 4,
      "ee_name": "sit amet ad",
      "username": "aliqua non sit dolore sint",
      "password": "Lorem in ut Duis"
    }
  ]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `status` | boolean | **Required** |

#### status

`status`

- is **required**
- type: `boolean`

##### status Type

`boolean`

### Output Example

```json
{ "status": false }
```

## ee_list

### Get list of available environments for software modules

`ee_list`

- type: `Method`

### ee_list Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | Optional     |
| `output` |        | **Required** |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type | Required |
| -------- | ---- | -------- |
| None     | None | None     |

### Ubus CLI Example

```
ubus call swmodules ee_list {}
```

### JSONRPC Example

```json
{ "jsonrpc": "2.0", "id": 0, "method": "call", "params": ["<SID>", "swmodules", "ee_list", {}] }
```

#### output

`output`

- is **required**
- type: complex

##### output Type

Unknown type ``.

```json
{
  "oneof": [
    {
      "type": "object",
      "properties": {
        "environment": {
          "type": "array",
          "items": [
            {
              "type": "object",
              "properties": {
                "ee_name": {
                  "type": "string"
                },
                "eeid": {
                  "type": "integer"
                },
                "status": {
                  "type": "string"
                },
                "pause": {
                  "type": "integer",
                  "minimum": 0,
                  "maximum": 1
                },
                "autoboot": {
                  "type": "integer",
                  "minimum": 0,
                  "maximum": 1
                },
                "type": {
                  "type": "string"
                },
                "vendor": {
                  "type": "string"
                },
                "version": {
                  "type": "string"
                },
                "allocated_disk_space": {
                  "type": "integer",
                  "minimum": 0
                },
                "available_disk_space": {
                  "type": "integer",
                  "minimum": 0
                },
                "allocated_memory": {
                  "type": "integer",
                  "minimum": 0
                },
                "available_memory": {
                  "type": "integer",
                  "minimum": 0
                },
                "parent_ee_ref": {
                  "type": "integer",
                  "minimum": 0
                }
              },
              "required": [
                "ee_name",
                "eeid",
                "status",
                "pause",
                "autoboot",
                "type",
                "vendor",
                "version",
                "allocated_disk_space",
                "available_disk_space",
                "allocated_memory",
                "available_memory",
                "parent_ee_Ref"
              ]
            }
          ]
        }
      }
    },
    {
      "type": "object",
      "properties": {
        "environment": {
          "type": "array",
          "items": []
        }
      }
    }
  ],
  "out": "{\"oneof\":[{\"environment\":[{\"ee_name\":\"Lorem in aliquip ea elit\",\"eeid\":-21467911,\"status\":\"laboris mollit\",\"pause\":1,\"autoboot\":1,\"type\":\"ea\",\"vendor\":\"pariatur aliqua in dolo\",\"version\":\"dolore\",\"allocated_disk_space\":91843673,\"available_disk_space\":80706298,\"allocated_memory\":28331192,\"available_memory\":49735843,\"parent_ee_ref\":39940718}]},{\"environment\":[]}]}",
  "simpletype": "complex"
}
```

### Output Example

```json
{
  "oneof": [
    {
      "environment": [
        {
          "ee_name": "Lorem in aliquip ea elit",
          "eeid": -21467911,
          "status": "laboris mollit",
          "pause": 1,
          "autoboot": 1,
          "type": "ea",
          "vendor": "pariatur aliqua in dolo",
          "version": "dolore",
          "allocated_disk_space": 91843673,
          "available_disk_space": 80706298,
          "allocated_memory": 28331192,
          "available_memory": 49735843,
          "parent_ee_ref": 39940718
        }
      ]
    },
    { "environment": [] }
  ]
}
```

## ee_set_state

### Change the current state of the Execution Environment

`ee_set_state`

- type: `Method`

### ee_set_state Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type    | Required     |
| --------- | ------- | ------------ |
| `ee_name` | string  | Optional     |
| `eeid`    | integer | Optional     |
| `state`   | string  | **Required** |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

#### state

`state`

- is **required**
- type: reference

##### state Type

`string`

The value of this property **must** be equal to one of the [known values below](#ee_set_state-known-values).

##### state Known Values

| Value  |
| ------ |
| start  |
| stop   |
| pause  |
| resume |

### Ubus CLI Example

```
ubus call swmodules ee_set_state {"state":"stop","eeid":-51049577,"ee_name":"id officia consectetur nostrud"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": [
    "<SID>",
    "swmodules",
    "ee_set_state",
    { "state": "stop", "eeid": -51049577, "ee_name": "id officia consectetur nostrud" }
  ]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `reason` | string  | **Required** |
| `status` | boolean | **Required** |

#### reason

`reason`

- is **required**
- type: `string`

##### reason Type

`string`

#### status

`status`

- is **required**
- type: `boolean`

##### status Type

`boolean`

### Output Example

```json
{ "status": true, "reason": "dolore adipisicing Ut in" }
```

## eu_list

### Get list of execution units (running packages)

`eu_list`

- type: `Method`

### eu_list Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` |        | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type    | Required |
| --------- | ------- | -------- |
| `ee_name` | string  | Optional |
| `eeid`    | integer | Optional |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

### Ubus CLI Example

```
ubus call swmodules eu_list {"eeid":2,"ee_name":"eiusmod"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "swmodules", "eu_list", { "eeid": 2, "ee_name": "eiusmod" }]
}
```

#### output

`output`

- is optional
- type: complex

##### output Type

Unknown type ``.

```json
{
  "oneof": [
    {
      "type": "object",
      "properties": {
        "execution_unit": {
          "type": "array",
          "items": [
            {
              "type": "object",
              "properties": {
                "eu_name": {
                  "type": "string"
                },
                "command": {
                  "type": "string"
                },
                "state": {
                  "type": "string"
                },
                "config": {
                  "type": "string"
                },
                "version": {
                  "type": "string"
                },
                "description": {
                  "type": "string"
                },
                "ee_name": {
                  "type": "string"
                },
                "eeid": {
                  "type": "integer",
                  "minimum": 1
                },
                "euid": {
                  "type": "integer",
                  "minimum": 0
                },
                "disk_space": {
                  "type": "integer",
                  "minimum": 0
                },
                "memory_space": {
                  "type": "integer",
                  "minimum": 0
                },
                "vendor": {
                  "type": "string"
                }
              },
              "required": [
                "eu_name",
                "command",
                "state",
                "config",
                "version",
                "description",
                "ee_name",
                "eeid",
                "euid",
                "disk_space",
                "memory_space",
                "vendor"
              ]
            }
          ]
        }
      }
    },
    {
      "type": "object",
      "properties": {
        "execution_unit": {
          "type": "array",
          "items": []
        }
      }
    }
  ],
  "out": "{\"oneof\":[{\"execution_unit\":[{\"eu_name\":\"in est aliqua aliquip\",\"command\":\"proident et \",\"config\":\"reprehenderit nisi qui esse\",\"version\":\"deserunt quis do qui laborum\",\"description\":\"ipsum fugiat non\",\"ee_name\":\"enim\",\"euid\":18216158,\"disk_space\":13070620,\"memory_space\":67344135,\"vendor\":\"consequat\",\"state\":\"enim sed dolore est elit\",\"eeid\":7}]},{\"execution_unit\":[]}]}",
  "simpletype": "complex"
}
```

### Output Example

```json
{
  "oneof": [
    {
      "execution_unit": [
        {
          "eu_name": "in est aliqua aliquip",
          "command": "proident et ",
          "config": "reprehenderit nisi qui esse",
          "version": "deserunt quis do qui laborum",
          "description": "ipsum fugiat non",
          "ee_name": "enim",
          "euid": 18216158,
          "disk_space": 13070620,
          "memory_space": 67344135,
          "vendor": "consequat",
          "state": "enim sed dolore est elit",
          "eeid": 7
        }
      ]
    },
    { "execution_unit": [] }
  ]
}
```

## eu_set_state

### Start or stop the execution of an EU

`eu_set_state`

- type: `Method`

### eu_set_state Type

`object` with following properties:

| Property | Type   | Required     |
| -------- | ------ | ------------ |
| `input`  | object | **Required** |
| `output` | object | Optional     |

#### input

`input`

- is **required**
- type: `object`

##### input Type

`object` with following properties:

| Property  | Type    | Required     |
| --------- | ------- | ------------ |
| `ee_name` | string  | Optional     |
| `eeid`    | integer | Optional     |
| `eu_name` | string  | **Required** |
| `state`   | boolean | **Required** |

#### ee_name

`ee_name`

- is optional
- type: `string`

##### ee_name Type

`string`

#### eeid

`eeid`

- is optional
- type: `integer`

##### eeid Type

`integer`

#### eu_name

`eu_name`

- is **required**
- type: `string`

##### eu_name Type

`string`

#### state

`state`

- is **required**
- type: `boolean`

##### state Type

`boolean`

### Ubus CLI Example

```
ubus call swmodules eu_set_state {"eu_name":"in do ea sed Excepteur","state":true,"eeid":93105262,"ee_name":"ipsum pariatur"}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": [
    "<SID>",
    "swmodules",
    "eu_set_state",
    { "eu_name": "in do ea sed Excepteur", "state": true, "eeid": 93105262, "ee_name": "ipsum pariatur" }
  ]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type    | Required |
| -------- | ------- | -------- |
| `status` | boolean | Optional |

#### status

`status`

- is optional
- type: `boolean`

##### status Type

`boolean`

### Output Example

```json
{ "status": false }
```
