# SWMODD

Software Module(`swmodd`) Daemon manages the lxc and OCI based containers(using liblxc and crun) and provides the Backend for Software Modules as defined in

- [USP](https://usp.technology/specification/index.pdf), and
- [CWMP](https://www.broadband-forum.org/technical/download/TR-069.pdf)

TR181 data model parameter exposed using bbf [DotSO Plugin](https://dev.iopsys.eu/bbf/bbfdm/-/blob/devel/README.md).

- [Device.SoftwareModules.](https://usp-data-models.broadband-forum.org/tr-181-2-15-1-usp.html#D.Device:2.Device.SoftwareModules.)

It is written in C programming language and depends on a number of libraries of OpenWrt for building and running.

## Good to Know
It currently has support for LXC containers and OCI specification based application containers.

Application containers has all the dependencies internally resolved, so it does not required further modification inside the container. An OCI based application container can be installed using `du_install` ubus method. After successful installation, the OCI container will be visible in `du_list` and `eu_list` ubus method.

LXC based containers might requires further addition of packages on top of the base container, currently procd based lxc containers along with opkg only supported. Addition of new service/packages done using `opkg`, so all the `opkg` limitations can be considered as limitation for `swmodd` as well with respect to listing/installing/upgrading packages/services.

>NOTE:
- Installation of lxc base container is out of scope of swmodd
- ExecEnv.1 is Virtual environment used for installation of application containers
- Installation of `opkg` based DU not supported on ExecEnv.1
- Application containers support installation from tar ball or container registry
- In lxc ExecEnv, only addon package/services shall be visible in `du_list/eu_list`

## Concepts and Workflow
`SWMODD` usages `lxc` library to interact with the lxc containers and `opkg` system utilities to manage the services running inside that lxc container, for OCI application containers it usages `crun` to maintain the life cycle of the container.

Installation of application container from image registry work as a add-on feature, and is dependent on external modules `skopeo` and `umoci`.

`swmodd` is used to manage the software modules and exposes the functionality over ubus, whereas `libswmodd.so` is `bbf` plugin which exposes the SoftwareModules functionality over TR181 using `libbbf_api`.

## swmodd uci
Below is the uci for swmodd

```bash
config globals 'globals'
        option enabled '1'
        option debug '1'
        option log_level '3'
        option lan_bridge 'br-lan'
        option root '/3rdParty'

config execenv 'execenv_1'
        option name 'lxc'
```

- root is the base directory for containers, it is advised to configure an external non-volatile file-system path in this option
- execenv.name contains the name of sub-directory inside root, which contains the containers base filesystem
- Also 'lan_bridge' need to point to a valid bridge where application containers network namespace shall be attached.

> Note: For more details about UCI schema click [here](https://dev.iopsys.eu/iopsys/swmodd/-/tree/devel/schema/uci/swmodd.json)

## Important topics
* [Tools](./docs/guide/tools.md)
* [Deployment of application containers](./docs/guide/application_container.md)
* [UCI parameters](./docs/api/uci/uci.md)

## Dependencies
`swmodd` compile time and run time dependencies.

### Build-Time Dependencies

To successfully build `swmodd`, the following libraries are needed:

| Dependency  | Link                                          | License                                |
| ----------- | --------------------------------------------- | -------------------------------------- |
| libuci      | https://git.openwrt.org/project/uci.git       | LGPL 2.1                               |
| libubox     | https://git.openwrt.org/project/libubox.git   | BSD                                    |
| ubus        | https://git.openwrt.org/project/ubus.git      | LGPL 2.1                               |
| liblxc      | https://linuxcontainers.org/downloads/lxc/    | LGPL-2.1-or-later BSD-2-Clause GPL-2.0 |
| opkg        | https://git.openwrt.org/project/opkg-lede.git | GPL-2.0                                |
| libuuid     | util-linux                                    | GPL-2.0                                |
| libcurl     | https://dl.uxnr.de/mirror/curl                | MIT                                    |


### Run-Time Dependencies

In order to run the `swmodd`, following dependencies are needed to be running/available before `swmodd`.

| Dependency |                   Link                        | License    |
| ---------- | --------------------------------------------- | ---------- |
| ubusd      | https://git.openwrt.org/project/ubus.git      | LGPL 2.1   |
| bbfdm      | https://dev.iopsys.eu/bbf/bbfdm.git           | BSD-3      |
| opkg       | https://git.openwrt.org/project/opkg-lede.git | GPL-2.0    |
| libcurl    | https://dl.uxnr.de/mirror/curl                | MIT        |
| umoci      | https://github.com/opencontainers/umoci.git   | Apache-2.0 |
| Skopeo     | https://github.com/containers/skopeo.git      | Apache-2.0 |

Apart from these dependencies, LXC-4.0 > also requires cgroup functionalities to be mounted separately, to do so, `swmodd-cgroup` package is used.
> `uspd` along with `bbf` is used to expose the SoftwareModule datamodel objects.
> umoci and skopeo required to pull images from container registries

