/*
 * swmod_common.h: Abstracted API for swmod
 *
 * Copyright (C) 2021-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 */

#ifndef SWMOD_COMMON_H
#define SWMOD_COMMON_H

#include <uci.h>

#define PARENT_EEID	1
#define PROC_PATH "/proc"
#define DW_TMP_DIR_PATH "/tmp"
#define DW_PKG_LOCAL_PATH DW_TMP_DIR_PATH"/dw_package.ipk"
#define MAX_ENV_VAR_BUFF 1620

enum swmod_du_opration_enum {
	SWMOD_INSTALL,
	SWMOD_UPDATE,
	SWMOD_REMOVE,
	__SWMOD_OP_MAX
};

typedef struct {
	time_t start;
	int operation;
	unsigned long instance;
	struct uci_section *section;
	char env_var[MAX_ENV_VAR_BUFF];
	char url[2049];
	char uname[257];
	char psw[257];
	char uuid[37];
	char env_name[32];
} PkgInfo;

bool memory_available(unsigned long req_kb, const char *dst);
unsigned long get_remote_file_size(const char *url, const char *uname, const char *pwd);
int download_remote_package(const char *url, const char *username, const char *password, const char *dst);

#endif //SWMOD_COMMON_H
