/*
 * swmod_api.h: Abstracted API for swmod
 *
 * Copyright (C) 2021-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Vivek Dutta <vivek.dutta@iopsys.eu>
 *
 * See LICENSE file for license related information.
 */

#ifndef __SWMOD_API_H
#define __SWMOD_API_H
#include <stdbool.h>
#include "swmod.h"
#include "tools.h"

int swmod_run_cmd(ExecEnv_t *ee, const char *cmd, char *output, int out_len);
int swmod_install_package(ExecEnv_t *env, PkgInfo *pkg, char *output, int outlen);
int swmod_update_package(ExecEnv_t *env, PkgInfo *pkg, char *output, int outlen);
int swmod_remove_package(ExecEnv_t *env, const PkgInfo *pkg, char *output, int outlen);
void swmod_change_ee_state(ExecEnv_t *env, char *state, struct blob_buf *bb);
void populate_execution_unit(ExecEnv_t *env);
void swmod_get_pid_detail(ExecEnv_t *env, int pid, char *cmdline, int cmd_len, int *vsize);
void swmod_set_service_state(ExecEnv_t *env, char *name, bool state, struct blob_buf *bb);
void swmod_get_env_info(ExecEnv_t *env);
void swmod_set_ee_alias(ExecEnv_t *env, const char *alias, struct blob_buf *bb);
void swmod_set_du_alias(ExecEnv_t *env, const char *uuid, const char *alias, struct blob_buf *bb);
void swmod_set_eu_alias(ExecEnv_t *env, const char *eu_name, const char *alias, struct blob_buf *bb);
void swmod_set_eu_autostart(ExecEnv_t *env, const char *eu_name, bool enable, struct blob_buf *bb);

#endif //__SWMOD_API_H
