/*
 * opkg_utils.h: OPKG utility functions
 *
 * Copyright (C) 2021-2023 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Vivek Dutta <vivek.dutta@iopsys.eu>
 *
 * See LICENSE file for license related information.
 */

#ifndef __OPKG_UTILS_H
#define __OPKG_UTILS_H
#include <stdbool.h>

int opkg_install_pkg(const char *pkg_name, char *output, int out_len);
int opkg_update_pkg(const char *pkg_name, char *output, int out_len);
int opkg_remove_pkg(const char *pkg_name, char *output, int out_len);
int opkg_get_version(const char *pkg_name, char *output, int out_len);

#endif //__OPKG_UTILS_H
