# How to build a sulu application container
Below are the dependency for building the sulu application container
 - [Buildah](https://github.com/containers/buildah/blob/main/install.md)
 - [Skopeo](https://github.com/containers/skopeo/blob/main/install.md)
 - [umoci](https://github.com/opencontainers/umoci#install)

Some command requires sudo access, running makefile shall prompt for the password.

Update following variables in [Makefile](./Makefile) to select the correct version of sulu

```bash
SULU_MIRROR:="https://download.iopsys.eu/iopsys/mirror/"
SULU_VERSION:="2773675239270b53b136cbc8553c5f0a34c3e617"
SULU_TAR="sulu-${SULU_VERSION}.tar.gz"
```

After installing the dependency and updating the Makefile, run below command to generate the application container
```bash
$ make
```

The application tar ball shall be available in the same directory with name `sulu.tar`
