# LXC Based container migration

Initially `swmodd` only has support for LXC based containers, which partially managed with lxc-auto for auto-start of containers.
Configuration of bundle root was limited to 'lxc.conf', since lxc containers in initial design mapped to an 'ExecEnv' in datamodel, so there were no function to add/remove containers from datamodel and hence all the configuration/deployments are handled with firmware defaults, so there was no need to store additional metadata regarding containers.

Latter support of OCI based application containers being added, which adds the possibility of adding/removing an application container as they are mapped with 'DeploymentUnit', so they can be managed using InstallDU() operation.

This also needs datamodel mapping extensions to store all these metadata, so that they are persistent across firmware upgrades and restarts and factory resets.


## Bit more inside on lxc container handling in older releases
1. LXC bundle root defined in '/etc/lxc/lxc.conf' with "lxc.lxcpath" option
2. Each LXC container mapped to 'Device.SoftwareModules.ExecEnv.' datamodel parameter
3. Auto-start of LXC based containers managed with the help of `lxc-auto` package and is stored in `/etc/config/lxcauto` file
4. LXC based container configuration stored in a `config` file inside build root path

So, the information is bit scattered and had too many dependencies on external modules, also some information does not persists across factory reset.

## After alignment with TR181-2.16
1. Defining the bundle root now moved to swmodd uci (Note: In deployment, its a best practice use a non-root persistent storage path for this option)

```bash
config globals 'globals'
        option root '/3rdParty'

config execenv 'execenv_1'
        option name 'container'
```

2. All containers (LXC/OCI) are treated application/service container and its mapped to DU (`Device.SoftwareModules.DeploymentUnits.`).
3. `Device.SoftwareModules.ExecEnv.` mapped to `execenv` section in swmodd UCI, which represents the sub directory inside the `root` path where all DUs are installed.
4. Datamodel metadata now stored in "ocicontainer" UCI file at `<root>/<name>/` for e.g `/3rdParty/container/`, to make it persistent across firmwareUpgrades/factoryResets/Reboots.
5. auto-boot dependency now removed, its now handled by swmodd itself based on "ocicontainer" UCI file.

Example of ocicontainer uci file:

```bash
config du_eu_assoc '<section_name>'
	option name '<container_name>'
	option type 'lxc'
   	option autostart '1'
	option requested_state 'Active'
	option du_status 'Installed'
	option uuid '<uuid>'
	option duid '<duid'>
	option ee_name '<execenv name>'
	option eu_name '<container_name>'
```

## Migration notes
1. lxc-auto shall not be used for managing lxc containers auto-start
2. uci-default script '01-fix-bundle-path' added to migrate the bundle-root to execenv configuration, its works as
  - If oci_bundle_root is set in /etc/config/swmodd then uci-default script writes the same in lxc.conf and configures the `root` and execenv section in swmodd UCI.
  - If oci_bundle_root is not defined but lxc_bundle_root is present then uci-default script writes the same in lxc.conf and configures the `root` and execenv section in swmodd UCI.
  - If both are not defined but lxc path is present in lxc.conf then uci-default script configures the `root` and execenv section in swmodd UCI with this value.
  - If none of the above three are valid then uci-default set `root` with "/srv" and execenv name with `lxc` in /etc/config/swmodd and set lxc path with `/srv/lxc' in lxc.conf.
3. uci-default script '02-migrate-lxc' added to migrate the lxc containers as DU in ocicontainer UCI file. It finds all available LXC containers inside `execenv` and add `du_eu_assoc` section in the ocicontainer file for the corresponding lxc.
4. uci-default script '03-execenv-ref' has been added to migrate the execution environment reference of each DUs in ocicontainer file, since earlier `system` i.e openwrt was treated as environment now every bundle_root would be treated as an environment.

> Note: Apart from the above described configuration if there is any customer specific configuration then that needs to be migrated additionaly.


## Summary

There has been a big shift in how containers mapped earlier and now with datamodel, but functionaly there should not be any impact. We have added couple to migration script to easily migrated from previous release/design to new release/design.


## References
- [OCI runtime specs](https://github.com/opencontainers/runtime-spec/blob/main/config.md)
- [LXC runtime specs](https://linuxcontainers.org/lxc/manpages/man5/lxc.container.conf.5.html)
- [LXC config manpages](https://manpages.ubuntu.com/manpages/trusty/man5/lxc.container.conf.5.html)
