# How to deploy application containers
`swmodd` support deployment of application containers which support OCI image and runtime formats using CRUN.

## How to create an application container tar
To convert an docker image to OCI application container, we need to use `skopeo` and `umoci` utilities.

In below exaple [httpd](https://hub.docker.com/_/httpd) docker container is used
- Create an empty directory in local laptop/desktop
```bash
$ mkdir lcm
$ cd lcm
```
- Copy the docker image using skopeo, make sure to use correct tag as per the target architecture
```bash
$ skopeo copy docker://httpd:latest oci:httpd_copy:latest
```
- Unpack the downloaded image in OCI format using umoci
```bash
$ sudo -i
# cd <working_dir_path>
# umoci unpack --image httpd_copy:latest httpd
```
- Move to the directory containing config.json and rootfs and create a tar
```bash
# cd httpd
# tar cf ../httpd.tar *
```

- Use this tar in `install_du` ubus command to deploy the application container

## Sulu application container
An example makefile to generate sulu application container tar ball can be accessed [here](https://dev.iopsys.eu/iopsys/swmodd/-/blob/devel/examples/sulu/README.md)

## Local application containers with multi-arch support
It is possible to create an multi-arch oci container and store it in Gitlab image registry, to support variety of devices and platforms.

This can be done in many ways, but in this example I am using docker buildx to build multi-arch containers.

### Pre-setup

1. Create a access-token with read/write access to image registry in gitlab
2. Install buildx

```bash
export BUILDX_VERSION="v0.10.4"
export BUILDX_ARCH="linux-amd64"
wget -O /usr/bin/docker-buildx https://github.com/docker/buildx/releases/download/${BUILDX_VERSION}/buildx-${BUILDX_VERSION}.${BUILDX_ARCH}
```

### Build
To build a multi-arch oci container and push to Gitlab image registry, run following commands, sulu example container used in this example:

```bash
$ docker-buildx create --use
$ cd examples/sulu
$ make extract
$ docker-buildx build --provenance=false --platform linux/386,linux/amd64,linux/arm/v6,linux/arm/v7,linux/arm64/v8 --tag dev.iopsys.eu:5050/lcm/swmodd/sulu:v2.1.2 --push .
```

Above commands creates sulu multi-arch containers and push it to Gitlab [image registry](https://dev.iopsys.eu/lcm/swmodd/container_registry/).

### Verify
Image details can be verified with docker manifest command:

```bash
vdutta@SW019:~$ docker manifest inspect dev.iopsys.eu:5050/lcm/swmodd/sulu
{
   "schemaVersion": 2,
   "mediaType": "application/vnd.docker.distribution.manifest.list.v2+json",
   "manifests": [
      {
         "mediaType": "application/vnd.docker.distribution.manifest.v2+json",
         "size": 1871,
         "digest": "sha256:5d362624ae3d27ecea7486a6b8f6a103b7d52543574baa483dd9034402727eb5",
         "platform": {
            "architecture": "386",
            "os": "linux"
         }
      },
      {
         "mediaType": "application/vnd.docker.distribution.manifest.v2+json",
         "size": 1871,
         "digest": "sha256:db776d064d0763874bca5f8c4a5f396e339a901350cbcc8714c5e19c3adcefc9",
         "platform": {
            "architecture": "amd64",
            "os": "linux"
         }
      },
      {
         "mediaType": "application/vnd.docker.distribution.manifest.v2+json",
         "size": 1871,
         "digest": "sha256:0323e482ca40f631a46993736b65459554149ac1586f04042cf61e738236bc64",
         "platform": {
            "architecture": "arm",
            "os": "linux",
            "variant": "v5"
         }
      },
      {
         "mediaType": "application/vnd.docker.distribution.manifest.v2+json",
         "size": 1871,
         "digest": "sha256:63d6bcea175828b4a8034b874948e774e40eea8f71657c6e0d7a4d5881662db8",
         "platform": {
            "architecture": "arm",
            "os": "linux",
            "variant": "v6"
         }
      },
      {
         "mediaType": "application/vnd.docker.distribution.manifest.v2+json",
         "size": 1871,
         "digest": "sha256:29152f374de66400c489413c2fcddfd26b8edad4c048efea57b0c17f07aa05ed",
         "platform": {
            "architecture": "arm",
            "os": "linux",
            "variant": "v7"
         }
      }
   ]
}
vdutta@SW019:~$
```

Above output provides the sha1 hash per architechture, to use a specific image in device, it can be used with its sha checksum hash, like below

```bash
obuspa -c operate "Device.SoftwareModules.InstallDU(URL=docker://dev.iopsys.eu:5050/lcm/swmodd/sulu@sha256:0323e482ca40f631a46993736b65459554149ac1586f04042cf61e738236bc64)"
```

This installs sulu for arm/v5 arch.

