# A sulu plugin

This is the barest working plugin structure. The `package.json` file must exist even if it has no keys. It starts off with some essential libraries for any widget that interacts with html, as well as development dependencies for strong typing (react, ts-node, vite) and automatic linting (eslint and eslint presets, prettier).

To enable automatic linting with the added dev dependencies, after you've initialized with `yarn`, add the following to a .vscode/settings.json:

```json
{
  "editor.codeActionsOnSave": {
    "source.fixAll": false
  }
}
```

You can compile it as-is with sulu-builder.

Any modifications to the `tsconfig.json` will be overriden by sulu's tsconfig. It is only here to enable typescript development features. Likewise, `/src/@types/sulu.d.ts` is there so you can make `sulu-base/*` imports with assertion that they will, after the build, be there.

You can add yarn package.json depenedencies as you would in any other repository. `node_modules` can be populated for development, they will be ignored in the build - a single consistent dependency list will be compiled. However, you need to use `yarn`. `npm`, or any other dependency manager, is not supported.

For more information visit sulu-builder's README.

# VSCode

Suggested vscode settings to work with eslint and tsconfig:

```json
{
  "eslint.format.enable": true,
  "editor.codeActionsOnSave": {
    "source.fixAll.eslint": true
  },
  "html.format.enable": false,
  "javascript.format.enable": true,
  "prettier.enable": true,
  "search.exclude": {
    "**/.git/*": true,
    "**/node_modules/*": true,
    "**/dist": true,
    "**/specmap.json": true
  },
  "[javascript]": {
    "editor.defaultFormatter": "esbenp.prettier-vscode"
  },
  "typescript.tsdk": "node_modules/typescript/lib"
}
```

tsconfig.json also contains settings that purely are there to avoid development time warnings. Note that plugin tsconfig is not transferred to output build, the core sulu tsconfig is used.