const { readJSONSync, readFileSync } = require("fs-extra");

function tryReadJSON (path, def = {}) {
  try {
    return readJSONSync(path) || def;
  } catch (e) {
    return def;
  }
} 

function tryReadFile (path, def = "") {
  try {
    return readFileSync(path).toString() || def;
  } catch (e) {
    return def;
  }
} 

module.exports = {
  tryReadJSON,
  tryReadFile
};
