const { describe, it, beforeEach, afterEach } = require("mocha");
const { transferSulu } = require("./transferSulu");
const assert = require("assert");
const fs = require("fs-extra");
const path = require("path");

const {
  macros,
  beforeEachTest,
  afterEachTest,
} = require("../../resources/tests");

const { testSuluDir, testWriteResultDir, mockSuluIndexContents, log } =
  macros();

describe("src/libs/stage1/transferSulu.spec.js", () => {
  beforeEach(() => {
    beforeEachTest();
  });
  afterEach(() => {
    afterEachTest();
  });
  describe("transferSulu()", () => {
    it("should transfer the entire sulu directory correctly", () => {
      transferSulu({
        sourcePath: testSuluDir,
        buildOutputPath: testWriteResultDir,
        log,
        buildManifest: {},
      });

      assert.strictEqual(
        fs
          .readFileSync(path.join(testWriteResultDir, "index.js"))
          .toString(),
        mockSuluIndexContents,
        "read that the index file was copied correctly"
      );

      assert.strictEqual(
        fs
          .readFileSync(path.join(testWriteResultDir, "src", "index.js"))
          .toString(),
        mockSuluIndexContents,
        "read that the nested index file was copied correctly"
      );
    });
    it("should NOT transfer node_modules nor yarn.lock", () => {
      transferSulu({
        sourcePath: testSuluDir,
        buildOutputPath: testWriteResultDir,
        log,
        buildManifest: {},
      });
      assert.strictEqual(
        fs.existsSync(path.join(testWriteResultDir, "node_modules")),
        false,
        "node_modules not copied"
      );
      // assert.strictEqual(fs.existsSync(path.join(testWriteResultDir, "yarn.lock")), false, "yarn.lock not copied");
    });
    it("should fail based on package.json existing or not", () => {
      assert.doesNotThrow(() => {
        transferSulu({
          sourcePath: testSuluDir,
          buildOutputPath: testWriteResultDir,
          log,
          buildManifest: {},
        });
      });
      fs.removeSync(path.join(testSuluDir, "package.json"));
      assert.throws(() => {
        transferSulu({
          sourcePath: testSuluDir,
          buildOutputPath: testWriteResultDir,
          log,
          buildManifest: {},
        });
      });
    });
  });
});
