import WidgetCard from "sulu-base/@components/WidgetCard";
import React, { useEffect, useState } from "react";
import { useTranslation } from "react-i18next";
import Clock from 'react-clock';
import { FaClock } from "react-icons/fa";
import {
  Center,
  Flex
} from "@chakra-ui/react";
import 'react-clock/dist/Clock.css';

// this is a mock component that does not access application state, but does import the expanding widget card.

export function MockClockComponent(): JSX.Element {
  const [value, setValue] = useState(new Date());
  const [t] = useTranslation("mock-plugin");

  useEffect(() => {
    const interval = setInterval(
      () => setValue(new Date()),
      1000
    );

    return () => {
      clearInterval(interval);
    }
  }, []);

  return (
    <WidgetCard
      title={t("PLUGIN.CLOCK_SAMPLE")} icon={FaClock}>
      <Flex width="100%" height="90%">
        <Center width="100%">
          <Clock value={value} />
        </Center>
      </Flex>
      <Flex width="100%" justifyContent="center" mt="2">
        <label>{t("PLUGIN.SUBSCRIPT")}</label>
      </Flex>
    </WidgetCard>
  )
}
