const replace = require("replace-in-file");

function matchAndReplace() {
  return {
    from: [
      /=( )*require\(("|')sulu-base(\/@.+)("|')\)(;)?$/gm,
      / from ("|')sulu-base(\/@.+)("|')(;)?$/gm,
    ],
    to: [
      (...g) => {
        const ret = `=${g[1] || ""}require(${g[2] || ""}${g[3] || ""}${
          g[4] || ""
        })\n`;
        return ret;
      },
      (...g) => {
        const ret = ` from ${g[1] || ""}${g[2] || ""}${g[3] || ""}${
          g[4] || ""
        }\n`;
        return ret;
      },
    ],
  };
}

function replaceImports({ src }) {
  const { from, to } = matchAndReplace();
  const results = replace.sync({
    files: src,
    from,
    to,
  });
}

module.exports = {
  matchAndReplace,
  replaceImports,
};
