#!/usr/bin/python3

import ubus
import json
import pathlib

TEST_NAME = "Validate NAT detection"

print("Running: " + TEST_NAME)

sock = pathlib.Path('/var/run/ubus/ubus.sock')
if sock.exists ():
    assert ubus.connect('/var/run/ubus/ubus.sock')
else:
    assert ubus.connect()

nat = ubus.call("bbfdm", "get", {"path":"Device.ManagementServer.NATDetected"})
print(nat)
#assert nat[0]["NATDetected"]==True, "NAT not detected, Please verify manually"

conreq = ubus.call("bbfdm", "get", {"path":"Device.ManagementServer.UDPConnectionRequestAddress"})
print(conreq)
#assert len(conreq[0]["UDPConnectionRequestAddress"])!=0, "Failed to get USP connection req"

ubus.disconnect()

print("PASS: " + TEST_NAME)
