/*
 * log.c : Conatain functions used to log traces
 *
 * Copyright (C) 2022 IOPSYS Software Solutions AB. All rights reserved.
 *
 * Author: Omar Kallel <omar.kallel@pivasoftware.com>
 *
 * See LICENSE file for license related information.
 *
 */

#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>
#include <syslog.h>
#include <time.h>

#include "common.h"

static const int log_syslogmap[] = {
	[CRIT] = LOG_CRIT,
	[WARNING] = LOG_WARNING,
	[NOTICE] = LOG_NOTICE,
	[INFO] = LOG_INFO,
	[DEBUG] = LOG_DEBUG
};

void SLOG(int priority, const char *format, ...)
{
	if (priority <= conf.loglevel) {
		va_list vl;

		va_start(vl, format);
		vsyslog(log_syslogmap[priority], format, vl);
		va_end(vl);
	}
}
