#ifndef _COMMON_H
#define _COMMON_H

#include <libubox/blobmsg.h>
#include <libubus.h>
#include <uci.h>
#include <syslog.h>

#define VAR_STATE "/var/state"
#define DEFAULT_SERVERPORT 3478
#define DEFAULT_CLIENTPORT 7547
#define DEFAULT_MINKEEPALIVE 30
#define DEFAULT_RETRYTIME 3
#define DEFAULT_MAXKEEPALIVE 3600
#define DEFAULT_LOGLEVEL INFO
#define UBUS_TIMEOUT 5000  /* 5 seconds */

#define DATAMODEL_OBJECT "bbfdm"

#ifndef STRLEN
#define STRLEN(SRC) ((SRC != NULL) ? strlen(SRC) : 0)
#endif

#ifndef FREE
#define FREE(x) do { if(x) {free(x); x = NULL;} } while (0)
#endif

enum stunc_log_level {
	CRIT,
	WARNING,
	NOTICE,
	INFO,
	DEBUG,
	__MAX_LEVEL
};

struct stun_config {
	char *server_address;
	char *username;
	char *password;
	int server_port;
	int client_port;
	int max_keepalive;
	int min_keepalive;
	int loglevel;
};

struct ubus_result {
	char path[1024];
	char value[4096];
};

extern struct stun_config conf;

void state_conf_init(void);
void get_acs_address(char **val);
int stunc_uci_init(void);
int stunc_uci_finish(void);
char *stunc_uci_get_value(const char *package, const char *section, const char *option);
char *stunc_uci_set_value(const char *package, const char *section, const char *option, const char *value, bool is_commit);
char *stunc_uci_get_value_state(const char *package, const char *section, const char *option);
char *stunc_uci_set_value_state(const char *package, const char *section, const char *option, const char *value);
int stunc_ubus_call(const char *path, const char *method, struct blob_attr *msg, struct ubus_result *output);
void SLOG(int priority, const char *format, ...);

#endif //_COMMON_H
