#!/bin/bash

function cleanup()
{
	echo ""
}

function check_ret()
{
	ret=$1
	if [ "$ret" -ne 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function error_on_zero()
{
	ret=$1
	if [ "$ret" -eq 0 ]; then
		echo "Validation of last command failed, ret(${ret})"
		exit $ret
	fi

}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		exit 1
	fi
}

function clean_stunc()
{
	make -C src clean
	rm *.gcno
	rm *.gcda
}

function build_stunc()
{
	export CFLAGS="-g -O0 -fprofile-arcs -ftest-coverage"
	export LDFLAGS="--coverage"

	make -C src
	exec_cmd ln -s ${PWD}/src/stunc /usr/sbin/stunc
}

function install_icwmp()
{
	[ -d "/opt/dev/icwmp" ] && rm -rf /opt/dev/icwmp

	if [ -n "${CWMP_BRANCH}" ]; then
		exec_cmd git clone -b ${CWMP_BRANCH} https://dev.iopsys.eu/bbf/icwmp.git /opt/dev/icwmp
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/icwmp.git /opt/dev/icwmp
	fi

	cd /opt/dev/icwmp
	./gitlab-ci/install-dependencies.sh
	./gitlab-ci/setup.sh
	. ./gitlab-ci/shared.sh
	build_icwmp
}
