#!/bin/bash

echo "$0 preparation script"
pwd

source ./gitlab-ci/shared.sh

# build package
date +%s > timestamp.log
clean_stunc
build_stunc

supervisorctl update
supervisorctl restart all
supervisorctl status all
exec_cmd ubus -t 20 wait_for bbfdm

echo "## Running python based verification of functionalities ##"
echo > ./funl-result.log
num=0
for test in `ls -1 ./test/python/*.py`
do
	#$test
	echo "Disable test for now"
	if [ $? -eq 0 ]; then
		echo "ok ${num} - $test" >> ./funl-result.log

	else
		echo "not ok ${num} - $test" >>  ./funl-result.log
	fi
	num=$(( num + 1 ))
done

echo "1..${num}" >> ./funl-result.log

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./funl-test-coverage.xml
gcovr -r .
exec_cmd tap-junit --input ./funl-result.log --output report

echo "Checking memory leaks..."
grep -q "Leak_DefinitelyLost" /tmp/memory-report.xml
error_on_zero $?

echo "Functional Test :: PASS"
