#!/bin/bash

echo "$0 preparation script"
pwd

source ./gitlab-ci/shared.sh

# build package
date +%s > timestamp.log
clean_stunc
build_stunc

supervisorctl update
supervisorctl restart all
supervisorctl status all
exec_cmd ubus -t 20 wait_for bbfdm

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./funl-test-coverage.xml
gcovr -r .

echo "Checking memory leaks..."
grep -q "Leak_DefinitelyLost" /tmp/memory-report.xml
error_on_zero $?

echo "Compilation Test :: PASS"
