# STUNC

Session Traversal Utilities for NAT (STUN) is a standardized set of method to reach the CPE devices that are connected behind NAT, the CWMP protocol introduces alternative method of executing Connection Request via NAT based on STUN. The stunc is an implementation of STUN client functionality that performs this feature.

## Project Components

Project consists of following components:

- Application itself written in C programming language
- Documentation in a Markdown format

## Build Instructions

`stunc` is written using C programming language and depends on a number of components found in `OpenWrt` for building and running.

## UCI Config

The `stunc` requires a configuration file to get the required input parameters which is located in **'/etc/config/stunc'** and contains only one section **stunc**:

```bash
config stunc 'stunc'
	option enabled '0'
	option username 'stun'
	option password 'stun'
	option server_address 'stun.l.google.com'
	option server_port '19302'
	option min_keepalive '30'
	option max_keepalive '3600'
	option client_port 7547
	option log_level '0'
```
For more info on the `stunc` UCI configuration see [link](./docs/api/uci/stunc.md)

## Concepts and Workflow
`stunc` is developed according to RFC-3489 to detect if CPE is behind a NAT network, when enabled. This package is specifically designed to provide stun client functionality for a CWMP client.

`stunc` monitors and calls below ubus method to inform CWMP client of incoming connection requests.

```bash
ubus call tr069 inform '{"event": "6 connection request"}'
```

Public IP/UDP connection request details along with nat-detection status is available in below path:
```bash
root@iopsys:~# cat /var/state/stunc
stunc.stunc.nat_detected='1'
stunc.stunc.crudp_address='157.37.187.219:48942'
```

## Dependencies

### Build-Time Dependencies
To successfully build `stunc`, the following libraries are needed:

| Dependency      | Link                                        | License        |
| --------------- | ------------------------------------------- | -------------- |
| libuci          | https://git.openwrt.org/project/uci.git     | LGPL 2.1       |
| libubox         | https://git.openwrt.org/project/libubox.git | BSD            |
| libubus         | https://git.openwrt.org/project/ubus.git    | LGPL 2.1       |
| libjson-c       | https://s3.amazonaws.com/json-c_releases    | MIT            |

### Run-Time Dependencies
In order to run the `stunc`, following dependencies are needed to be running/available before `stunc`.

| Dependency |                   Link                   | License  |
| ---------- | ---------------------------------------- | -------- |
| ubusd      | https://git.openwrt.org/project/ubus.git | LGPL 2.1 |

