# SSHD as backend

The ssh daemon provided by OpenSSH is called sshd. This document provides an outline of its behaviour,
to aid understand the behaviour and configuration when using sshd as backend for sshmngr.

## Migration from dropbear

If a system is upgraded with an image with sshd as backend, then:

- sshd will check for dropbear config file on first start up, for example if an upgrade was done without defaultreset (i.e., keep settings) and dropbear was present in the previous image.

If a dropbear config is found, sshd will:

- try to generate an sshd config as similar as possible to the dropbear config, and then remove the dropbear config file
- copy the /etc/dropbear/authorized_keys file to the place where sshd expects them, and then remove the dropbear authorized_keys

Otherwise system will come up with the default sshd config, given further in this document.

## Configuration

- The UCI file for sshd is called "sshd".
- Each section of the UCI file represents an ssh server.
- The section can be of the type "sshd".
- The datamodel maps one-to-one to the sshd uci file.

### Options

- The default here applies if the option is not used.

| Name              | Type          | Default     | Description |
| :---              | :----:        | :---:       | :---        |
| AllowUsers        | list (string) | empty       | usernames allowed to log in, no value means all users |
| BannerFile        | string        | empty       | the path to the file containing the banner used in ssh |
| Ciphers           | list (string) | empty       | the Ciphers that can be used, no value means all |
| enable            | bool          | true        | whether this server is enabled or not |
| GatewayPorts      | bool          | false       | whether remote hosts are allowed to connect to forwarded ports |
| HostKeyAlgorithms | list (string) | empty       | the HostKeyAlgorithms that can be used, no value means all |
| HostKeyFiles      | list (string) | empty       | the file(s) pointing to HostKey(s), no value means sshd default |
| IdleTimeout       | number        | 0           | how many seconds before unresponsive SSH clients will be disconnected |
| Interface         | string        | empty       | interface whose address to bind to, no value means all interfaces |
| KexAlgorithms     | list (string) | empty       | the KexAlgorithms that can be used |
| MacAlgorithms     | list (string) | empty       | the available MAC (message authentication code) algorithm, no value means all |
| MaxAuthTries      | number        | 6           | number of authentication attempts allowed |
| mdns              | bool          | true        | whether to announce an ssh service over mdns |
| PasswordAuth      | bool          | true        | whether to allow password based authentication |
| Port              | number        | 22          | port to listen on |
| RootLogin         | bool          | true        | whether to allow authentication for root |
| RootPasswordAuth  | bool          | true        | whether to allow password based authentication for root |

- For more details about these options please follow *sshd_config* manual page.

### IOWRT default sshd config

- There is an iowrt default config with which the device comes up, which is different and as follows:

```
config sshd
        option enable '1'
        option Port '22'
        option RootLogin '1'
        option PasswordAuth '1'
        option RootPasswordAuth '1'
        list AllowUsers 'root'
        list MacAlgorithms 'hmac-sha1'
        list MacAlgorithms 'hmac-sha2-256'
        list MacAlgorithms 'hmac-sha2-512'
        list Ciphers 'aes128-ctr'
        list Ciphers 'aes192-ctr'
        list Ciphers 'aes256-ctr'
        list HostKeyAlgorithms 'ecdsa-sha2-nistp256'
        list HostKeyAlgorithms 'ecdsa-sha2-nistp384'
        list HostKeyAlgorithms 'ecdsa-sha2-nistp521'
        list HostKeyAlgorithms 'ssh-rsa'
        list HostKeyAlgorithms 'ssh-dss'
        list KexAlgorithms 'ecdh-sha2-nistp256'
        list KexAlgorithms 'ecdh-sha2-nistp384'
        list KexAlgorithms 'ecdh-sha2-nistp521'
        list KexAlgorithms 'diffie-hellman-group14-sha1'
        list KexAlgorithms 'diffie-hellman-group-exchange-sha256'
```

- Please note that the following options are not configurable via TR181 and hence must be properly set in the customer default UCI config or represented by vendor extensions:

```
1. AllowUsers
2. BannerFile
3. MacAlgorithms
4. Ciphers
5. GatewayPorts
6. HostKeyAlgorithms
7. HostKeyFiles
8. KexAlgorithms
```

### AuthorizedKeys

- Client authorized keys allow to authenticate a client without a password.
- Client authorized keys can be generated at the client using the ssh-keygen utility. For more details on this, please refer to *ssh-keygen manpage*.
- Client authorized keys can be added/removed via sshmngr ubus functions or by directly modifying following file (for sshd):

```
/root/.ssh/authorized_keys
```
or by executing the following at the client side
```
ssh-copy-id username@remote_host
```

## Notes

### MaxAuthTries behaviour (Too many authentication failures)

This is one of the most frequent complain we recieve when using openssh, please find some guidelines to understanding the actual cause of the problem and how to fix it.

- When we try to ssh onto a server from the client side, then the client makes authentication attempts to the server, most commonly using public-keys or passwords.
- When an ssh attempt is made by the client without specifying *option PreferredAuthentications*, the client first tries to authenticate by sending its public-keys.
- It is only when the public-key based authentication fails that the client falls back to password based authentication.
- Please note that there could be more than one public-keys available at the client and while usually the client sends one public-key, it depends on the ssh-client config as to how many public-keys will it try authenticating with before falling back to password.
- On the sshd server, *option MaxAuthTries* configures the number of authentication attempts that are allowed over an ssh connection attempt, its default value is 6.
- Therefore, if a client tries 6 or more keys and none of them work, then error will be displayed without even asking for a password, even if the *option MaxAuthTries* is set to 6.
- This could also lead you to believe that the value set for *option MaxAuthTries* by you, is not taking effect since the attempts to authenticate with the public-keys are usually invisible to the eye (unless you are using ssh -v).
- To avoid this problem you could force the sshd **clients** (common for Linux users) to only password based authentication as follows:

```
ssh -o PreferredAuthentications=password <user>@<device-ip>
```
- You could also delete obstelete keys to avoid unnecessary authentication attempts.

### Fixed number of password prompts by sshd client

Another problem that we commonly come across is that even when the value for *option MaxAuthTries* at the sshd server is set to a value greater than 3, the sshd client still prompts only for 3 passwords attempts before giving up and closing the ssh connection. Please find some guidelines to understanding the cause of this and to work around this problem as follows:

- The number of password prompts is not just controlled by the *option MaxAuthTries* on the sshd server, but also the *option NumberOfPasswordPrompts* on the sshd client.
- By default, sshd **clients** (common for Linux users) only allow 3 password attempts since the default value of *option NumberOfPasswordPrompts* is 3.
- This can be changed by setting option **NumberOfPasswordPrompts** in **ssh_config** on the client side
```
Add the following line to /etc/ssh/ssh_config on the client:

NumberOfPasswordPrompts 6
```
or by passing it as a command line option like,
```
ssh -o PreferredAuthentications=password -o NumberOfPasswordPrompts=6 <user>@<device-ip>
```

It is strongly advised to not use a value of *option NumberOfPasswordPrompts* at the client side which is less than the value of *option MaxAuthTries* at the server side.


- In general, if something goes wrong with your attempt to ssh onto the device, its always good to check what is exactly going wrong by doing a more verbose ssh attempt with the option *-v*

```
ssh -v <user>@<device-ip>
```
