# TR-181 SSH data-model

Aim of this document is to explain how the Device.SSH.Server and Device.SSH.AuthorizedKeys datamodel objects are mapped in backend.

As per the definition in TR-181:

- Device.SSH.Server allows setting up SSH servers.
- Device.SSH.AuthorizedKey allows adding client public keys to use key based authentication.

## UCI Configuration

- The UCI for sshd and dropbear is similar except for some options.

### Options availability

| Option           | dropbear | sshd     |
| :---             | :----:   | :---:    |
| SSHKeepAlive     | Present  | Absent   |
| RecvWindowSize   | Present  | Absent   |
| rsakeyfile       | Present  | Absent   |
| keyfile          | Present  | Absent   |
| verbose          | Present  | Absent   |
| AllowUsers       | Absent   | Present  |
| MacAlgorithms    | Absent   | Present  |


- For dropbear options, please visit dropbear UCI help web page.
- For sshd options, please visit: [docs/guide/sshd.md](./docs/guide/sshd.md) file.

### Default config

```
config sshd
	option enable '1'
	option Port '22'
	option RootLogin '1'
	option PasswordAuth '1'
	option RootPasswordAuth '1'
	list AllowUsers 'root'
	list MacAlgorithms 'hmac-sha1'
	list MacAlgorithms 'hmac-sha2-256'
	list MacAlgorithms 'hmac-sha2-512'
```

## TR-181 data-model example

The following UCI and TR-181 data model configuration is equivalent:

### sshd UCI

```
config sshd 'server_1'
	option enable '1'
	option Port '22'
	option IdleTimeout '180'
	option RootLogin '1'
	option PasswordAuth '1'
	option RootPasswordAuth '1'
	option MaxAuthTries '3'
	option Interface 'wan'
```

### TR-181 data-model

```
root@iopsys:~# icwmpd -c get Device.SSH.
Device.SSH.ServerNumberOfEntries => 1
Device.SSH.AuthorizedKeyNumberOfEntries => 0
Device.SSH.Server.1.Enable => 1
Device.SSH.Server.1.Alias => cpe-1
Device.SSH.Server.1.Interface => Device.IP.Interface.2
Device.SSH.Server.1.Port => 22
Device.SSH.Server.1.IdleTimeout => 180
Device.SSH.Server.1.KeepAlive => 300
Device.SSH.Server.1.AllowRootLogin => 1
Device.SSH.Server.1.AllowPasswordLogin => 1
Device.SSH.Server.1.AllowRootPasswordLogin => 1
Device.SSH.Server.1.MaxAuthTries => 3
Device.SSH.Server.1.ActivationDate => 2024-04-02T09:13:24+02:00
Device.SSH.Server.1.PID => 17425
Device.SSH.Server.1.SessionNumberOfEntries => 1
Device.SSH.Server.1.Session.1.IPAddress => 192.168.20.6
Device.SSH.Server.1.Session.1.Port => 54950
Device.SSH.AuthorizedKey.1.Alias => cpe-1
Device.SSH.AuthorizedKey.1.Key => <some-client-public-key>
```

### Operate command

Data model provides us with an operate command to kill a specific session of a specific server. For example:

```
obuspa -c operate "Device.SSH.Server.1.Session.1.Delete()"
```

### Ubus methods

```
root@iopsys:~# ubus -v list sshmngr
'sshmngr' @0ec7131a
	"dump":{"server_name":"String"}
	"kill_session":{"session_pid":"String","server_name":"String"}
	"list_keys":{}
	"add_pubkey":{"current_key":"String","new_key":"String"}
	"remove_pubkey":{"key":"String"}
```

- *dump*: dump information about servers and sessions.
- *kill_session*: we can kill individual session or all sessions of a server.
- *list_keys*: list authorized keys.
- *add_pubkey*: if current_key is present, then replace, otherwise add a public key (authorized key).
- *remove_pubkey*: remove public key of a client (authorized key).
