/* SPDX-License-Identifier: GPL-2.0 */
/*
 * qosmngr.h - definitions used in qosmngr
 *
 * Copyright (C) 2020 iopsys Software Solutions AB. All rights reserved.
 *
 * Author: Oskar Viljasaar <oskar.viljasaar@iopsys.eu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef QOSMNGR_H
#define QOSMNGR_H

/* Needed to get the IFNAMSIZ define */
#include <net/if.h>

#include <qos.h>

/* logging though syslog */
#include <libbbfdm-api/dmcommon.h>

/* UCI definitions, used to parse the config files at their right location */
#define UCI_CONFIG_QOS   "qos"

#define QOS_SECTION_NAME "queue"

#define OPT_ENABLE       "enable"
#define OPT_IFNAME       "ifname"
#define OPT_PRECEDENCE   "precedence"
#define OPT_SCHEDULING   "scheduling"
#define OPT_RATE         "rate"
#define OPT_BURST_SIZE   "burst_size"
#define OPT_WEIGHT       "weight"

#define QOS_MIN_Q_NUM_PER_PORT 4 //default minimum number of queue per port

enum {
      QOS_POLICY_IFNAME,
      QOS_POLICY_QID,
      QOS_POLICY_MAX,
      NUM_QOS_POLICY = QOS_POLICY_MAX,
};

extern const struct blobmsg_policy get_status_policy[NUM_QOS_POLICY];

/* A QoS queue. */
struct qos_queue {
	bool enable;
	struct qos_queue_config config;
	char name[IFNAMSIZ];
};

typedef struct protocol_list {
	struct list_head list;
	int proto_num;
	char proto_name[32];
} protocol_list_t;

int init_qstat(void);
void free_qstat(void);
int qosmngr_get_stats(struct ubus_context *ctx, struct ubus_object *obj,
		       struct ubus_request_data *req, const char *method,
		       struct blob_attr *msg);
int prepare_stats_blob(struct blob_buf *b, struct qos_stats *stats, void *dd,
				char *ifname, int qid);
#endif /* QOSMNGR_H */
