#!/bin/bash

echo "install dependencies"

home=$(pwd)

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1
	local ret=$?

	if [ "${ret}" -ne 0 ]; then
		echo "Failed to execute $@ ret (${ret})"
		exit 1
	fi
}

function install_bbfdm()
{
	[ -d "/opt/dev/bbfdm" ] && rm -rf /opt/dev/bbfdm

	if [ -n "${BBFDM_BRANCH}" ]; then
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	./gitlab-ci/install-dependencies.sh install
	./gitlab-ci/setup.sh install
}

# libqos
function install_libqos()
{
	cd /opt/dev
	rm -fr libqos
	exec_cmd git clone -b "${LIBQOS_BRANCH:-devel}" https://dev.iopsys.eu/hal/libqos.git

	cd libqos
	make PLATFORM=TEST

	cp include/qos.h /usr/include
	cp -a libqos.so* /usr/lib
	sudo ldconfig
}

# bbfdm
install_bbfdm
install_libqos
