# QoS Manager

This program implements methods provided by the `qos` object on U-Bus. This is done by calling `libqos` provided by `easy-soc-libs`.

## UCI Config

qosmngr requires a configuration file provide objects over ubus. The configuration file is an uci file `/etc/config/qos`. Sample configuration file is provided below.

```
config queue 'q_0_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '0'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_1_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '1'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_2_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '2'
        option scheduling 'SP'
        option rate '0'
        option weight '1'
        option burst_size '0'

config queue 'q_3_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '3'
        option scheduling 'SP'
        option rate '0'
        option weight '1'
        option burst_size '0'

config queue 'q_4_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '4'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_5_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '5'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_6_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '6'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_7_eth1'
        option enable '1'
        option ifname 'eth1'
        option precedence '7'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_0_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '0'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_1_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '1'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_2_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '2'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_3_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '3'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_4_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '4'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_5_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '5'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_6_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '6'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_7_eth2'
        option enable '1'
        option ifname 'eth2'
        option precedence '7'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_0_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '0'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_1_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '1'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_2_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '2'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_3_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '3'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_4_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '4'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_5_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '5'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_6_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '6'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_7_eth3'
        option enable '1'
        option ifname 'eth3'
        option precedence '7'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_0_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '0'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_1_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '1'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_2_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '2'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_3_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '3'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_4_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '4'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_5_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '5'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_6_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '6'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_7_eth4'
        option enable '1'
        option ifname 'eth4'
        option precedence '7'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_0_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '0'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_1_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '1'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_2_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '2'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_3_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '3'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_4_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '4'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_5_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '5'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_6_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '6'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config queue 'q_7_eth0'
        option enable '1'
        option ifname 'eth0'
        option precedence '7'
        option scheduling 'SP'
        option rate '0'
        option burst_size '0'
        option weight '1'

config classify 'cfg298143'
        option enable '1'
        option src_vendor_class_id '234be'
        option src_user_class_id '234be'
        option dst_vendor_class_id '234be'
        option dst_user_class_id '234be'
        option dst_client_id '34ab'
        option src_client_id '34ab'
        option vid_check '23'
        option traffic_class '3'
        option src_port '1'
        option dest_port '1'
        option src_port_range '-1'
        option dest_port_range '-1'
        option ifname 'eth0'
        option policer 'cfg2b6c73'
        option ethertype '0'
        option dhcp_type '0'
        option proto '1'
        option ip_len_min '0'
        option ip_len_max '0'
        option dest_ip '1.2.3.4'
        option src_ip '4.3.2.1'
        option pcp_check '1'
        option src_mac 'aa:bb:cc:dd:ee:ff'
        option dst_mac 'e8:bc:c3:dc:23:f4'
        option dscp_filter '1'
        option dscp_mark '1'

config shaper
        option enable '0'
        option burst_size '0'
        option rate '0'
        option ifname 'eth0'

config policer
        option enable '1'
        option committed_rate '0'
        option committed_burst_size '0'
        option excess_burst_size '0'
        option peak_rate '0'
        option peak_burst_size '0'
        option meter_type '0'
        option name 'cfg2b6c73'

```

## uBus API

`ubusd` has to be running all time, as it exposes the qos functionality over ubus. By default,qosmngr registers below namespace with ubus.

```
root@iopsys:~# ubus -v list | grep qos
'qos' @e1f3b458
root@iopsys:~# 
```

```
root@iopsys:~# ubus -v list qos
'qos' @e1f3b458
        "queue_stats":{"ifname":"String","qid":"String"}
        "reload":{"section":"String"}
root@iopsys:~# 
```

```
root@iopsys:~# 
root@iopsys:~# ubus -S call qos reload
root@iopsys:~# 
root@iopsys:~# ubus -S call qos reload '{"section":"classify"}'
root@iopsys:~# 
root@iopsys:~# ubus -S call qos reload '{"section":"queues"}'
root@iopsys:~# 
root@iopsys:~# ubus -S call qos reload '{"section":"policer"}'
root@iopsys:~# 
root@iopsys:~# ubus -S call qos reload '{"section":"shaper"}'
root@iopsys:~# 
```

- `queue_stats  : {"ifname":"String","qid":"Integer"}`
    - `ifname`: interface name for which we want to get the QoS statistics. Optional argument: if not provided, the statistics of all ports for all queues are returned.
    - `qid`: the TX queue ID for which we want to get the statistics. Optional argument: if not provided, the statistics of all queues for a given interface are returned.

    The response given by this method is a JSON-formatted dump as such:
```
    root@iopsys:~# ubus  call qos queue_stats '{"ifname":"eth1","qid":1}'
    {
	"queues": [
		{
			"iface": "eth1",
			"qid": 1,
			"tx_packets": 13632,
			"tx_bytes": 1377736,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		}
	]
    }
    root@iopsys:~# ubus call qos queue_stats '{"ifname":"eth0"}'
    {
	"queues": [
		{
			"iface": "eth0",
			"qid": 0,
			"tx_packets": 20,
			"tx_bytes": 4436,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 1,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 7,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		}
	]
    }
    root@iopsys:~# ubus call qos queue_stats
    {
	"queues": [
		{
			"iface": "eth1",
			"qid": 0,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 1,
			"tx_packets": 7575,
			"tx_bytes": 1186770,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth1",
			"qid": 7,
			"tx_packets": 199,
			"tx_bytes": 20540,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 0,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 1,
			"tx_packets": 2852,
			"tx_bytes": 295268,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth2",
			"qid": 7,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 0,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 1,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth3",
			"qid": 7,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 0,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 1,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth4",
			"qid": 7,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 0,
			"tx_packets": 3,
			"tx_bytes": 1038,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 1,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 2,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 3,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 4,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 5,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 6,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		},
		{
			"iface": "eth0",
			"qid": 7,
			"tx_packets": 0,
			"tx_bytes": 0,
			"tx_dropped_packets": 0,
			"tx_dropped_bytes": 0
		}
	]
    }

```
