# qos Schema

```
http://example.com/root.json
```

| Custom Properties | Additional Properties |
| ----------------- | --------------------- |
| Forbidden         | Permitted             |

# qos

| List of Methods             |
| --------------------------- |
| [queue_stats](#queue_stats) | Method | qos (this schema) |
| `*`                         | any | Additional | Yes | this schema _allows_ additional properties |

## queue_stats

`queue_stats`

- type: `Method`

### queue_stats Type

`object` with following properties:

| Property | Type   | Required |
| -------- | ------ | -------- |
| `input`  | object | Optional |
| `output` | object | Optional |

#### input

`input`

- is optional
- type: `object`

##### input Type

`object` with following properties:

| Property | Type    | Required     |
| -------- | ------- | ------------ |
| `ifname` | string  | Optional     |
| `qid`    | integer | Optional     |

#### ifname

##### Interface

`ifname`

- is **required**
- type: reference

##### ifname Type

`string`

- minimum length: 1 characters
- maximum length: 16 characters

#### qid

`qid`

- is optional
- type: `integer`

##### qid Type

`integer`

- minimum value: `0`

### Ubus CLI Example

```
ubus call qos queue_stats {"ifname":"irure e","qid":73828543}
```

### JSONRPC Example

```json
{
  "jsonrpc": "2.0",
  "id": 0,
  "method": "call",
  "params": ["<SID>", "qos", "queue_stats", { "ifname": "irure e", "qid": 73828543 }]
}
```

#### output

`output`

- is optional
- type: `object`

##### output Type

`object` with following properties:

| Property | Type  | Required     |
| -------- | ----- | ------------ |
| `queues` | array | **Required** |

#### queues

`queues`

- is **required**
- type: `object[]`

##### queues Type

Array type: `object[]`

All items must be of the type: `object` with following properties:

| Property             | Type    | Required     |
| -------------------- | ------- | ------------ |
| `iface`              | string  | **Required** |
| `qid`                | integer | **Required** |
| `tx_bytes`           | integer | **Required** |
| `tx_dropped_bytes`   | integer | **Required** |
| `tx_dropped_packets` | integer | **Required** |
| `tx_packets`         | integer | **Required** |

#### iface

##### Interface

`iface`

- is **required**
- type: reference

##### iface Type

`string`

- minimum length: 1 characters
- maximum length: 16 characters

#### qid

`qid`

- is **required**
- type: `integer`

##### qid Type

`integer`

- minimum value: `0`

#### tx_bytes

`tx_bytes`

- is **required**
- type: `integer`

##### tx_bytes Type

`integer`

- minimum value: `0`

#### tx_dropped_bytes

`tx_dropped_bytes`

- is **required**
- type: `integer`

##### tx_dropped_bytes Type

`integer`

- minimum value: `0`

#### tx_dropped_packets

`tx_dropped_packets`

- is **required**
- type: `integer`

##### tx_dropped_packets Type

`integer`

- minimum value: `0`

#### tx_packets

`tx_packets`

- is **required**
- type: `integer`

##### tx_packets Type

`integer`

- minimum value: `0`

### Output Example

```json
{
  "queues": [
    {
      "qid": 57381086,
      "iface": "magna",
      "tx_packets": 90338294,
      "tx_bytes": 40910869,
      "tx_dropped_packets": 87652250,
      "tx_dropped_bytes": 17334988
    },
    {
      "qid": 87546130,
      "iface": "eiusm",
      "tx_packets": 76154668,
      "tx_bytes": 74709969,
      "tx_dropped_packets": 17965,
      "tx_dropped_bytes": 40734824
    },
    {
      "qid": 34430984,
      "iface": "cupidatat ",
      "tx_packets": 95305765,
      "tx_bytes": 97035384,
      "tx_dropped_packets": 40769776,
      "tx_dropped_bytes": 44316439
    },
    {
      "qid": 94131182,
      "iface": "in ",
      "tx_packets": 14061137,
      "tx_bytes": 2161147,
      "tx_dropped_packets": 4207125,
      "tx_dropped_bytes": 5070078
    }
  ]
}
```

