#!/bin/bash

echo "preparation script"
pwd

make coverage -C ./
supervisorctl status all
supervisorctl update
sleep 3
supervisorctl status all

# run API validation
echo "Validating ubus api with ubs-api-validator"
ubus-api-validator -d ./test/api/json/ > ./api-result.log
echo "Please check test result under pipeline test tab."

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./api-test-coverage.xml
gcovr -r .
cp /opt/work/memory-report.xml /builds/iopsys/qosmngr/api-test-memory-report.xml
tap-junit --input ./api-result.log --output report
date +%s > timestamp.log



