# qosmngr

## About qosmngr

The package qosmngr is, as the name suggests the package that managed quality
of service configuration, both layer 2 and layer 3 and allows reading queue
level stats.

## Features

- Configuration of queues.
- Configuration of classfication rules for traffic segregation.
- Configuration of egress shaping and rate limiting.
- Configuration of ingress policing subject to support in SoC.
- Reading queue stats

## Configuration of queues

The default uci configuration of queues is generated based on the number of
queues available on the target. It is preferred to have 8 queues per port
however, on certain targets, due to non availability of sufficient number of
queues, 4 queues are generated per port.

A typical queue config looks as follows

```
config queue 'q_0_eth0'
	option enable '1'
	option ifname 'eth0'
	option precedence '8'
	option scheduling 'SP'
	option rate '0'
	option burst_size '0'
	option weight '1'
```

you can modify any of the params based on your preferance and use case and reload
qos for it to take effect.

## Configuration of classification rules

Classification rules, as we said earlier allow traffic segregation. There are 2 types
of parameters in each classification rules

- classification criteria
- classification result

The classification criterias are used to filter or match the packet on which we want
to apply the classification result.

The classification result defines the action to be taken on the packet that matches
the classificaiton criteria. Following uci options are classification results
- traffic_class
- forwarding_policy

the rest of the params in a classify section are all classification criterias.

The option traffic_class associates a traffic class with a packet. There is a
one to one mapping of traffic class and queue ids so for example traffic class
value 0 corresponds to queue 0 on a port and so on and so forth. So, if we want
to place a packet in queue 0 then we should assign traffic class value 0 to it.

configuration example for putting all icmp packet is queue 1

```
config classify 'c5'
	option proto 'icmp'
	option ethertype 'IPv4'
	option traffic_class '1'
```

The option forwarding_policy associates a routing table with a packet. This
particularly comes in handy when configuring source based routing. Please note
that the value of this option should be the same as the id of the routing table
that you want to be consulted for routing decision on this packet.

configuration example for routing all packet from eth0 via routing table 100

```
config classify 'c5'
	option ifname 'eth0'
	option forwarding_policy '100'
```


## Reading stats

After ubus starts, the qos methods can be invoked to get the queue information

```
root@iopsys:~# ubus call qos queue_stats '{"ifname":"eth0", "qid": 5}'
{
        "queues": [
                {
                        "qid": 5,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                }
        ]
}
```

For all available queue_stats the command can be used without parameters, such as

```
root@iopsys:~# ubus call qos queue_stats 
{
        "queues": [
                {
                        "qid": 0,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth1",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 0,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth2",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 0,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth3",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 0,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth4",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 0,
                        "iface": "eth0",
                        "tx_packets": 624,
                        "tx_bytes": 165216,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                }
        ]
}
```

We can call ubus for specific port such as : 


```
root@iopsys:~# ubus call qos queue_stats '{"ifname":"eth0"}'
{
        "queues": [
                {
                        "qid": 0,
                        "iface": "eth0",
                        "tx_packets": 543,
                        "tx_bytes": 143418,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 1,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 2,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 3,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 4,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 5,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 6,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                },
                {
                        "qid": 7,
                        "iface": "eth0",
                        "tx_packets": 0,
                        "tx_bytes": 0,
                        "tx_dropped_packets": 0,
                        "tx_dropped_bytes": 0
                }
        ]
}
```
