## About DSCP-to-Pbit mapping

DSCP-to-Pbit mapping refers to the process of associating Differentiated Services Code Point (DSCP)
values with Priority Bits (Pbits) in a network.

## Mapping Rule

A mapping rule defines how specific DSCP values are associated with Pbits.
For example:

If DSCP value is 2, the mapped Pbit is 3.
For DSCP values 23, 24, 25, 26, 27, the mapped Pbit is 1.

## Configuration of mapping rule

The mapping rule can be configured as a generic rule system wide, but it is
a better strategy to have it configured on ingress traffic per port basis.
In this case there is one config section per mapping rule per port.

For example:
To configure all 64 DSCP-to-Pbit mapping on port eth0.2 the following config
can be used:

```bash
config classify 'c1'
    option order '1 '
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '0'
    option pcp_mark '2'

config classify 'c2'
    option order '2 '
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '1'
    option pcp_mark '2'

config classify 'c3'
    option order '3'
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '2'
    option pcp_mark '3'

config classify 'c4'
    option order '4'
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '3'
    option pcp_mark '3'

config classify 'c5'
    option order '5'
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '4'
    option pcp_mark '4'

config classify 'c6'
    option order '6'
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '5'
    option pcp_mark '4'
.
.
.
config classify 'c64'
    option order '64'
    option enable '1'
    option ifname 'eth0.2'
    option dscp_filter '63'
    option pcp_mark '7'
```

Adding mapping rule via TR181:
- Add Device.QoS.Classification. object.
- Set port name, Device.QoS.Classification.{i}.Interface
Note: generally its a reference to Device.Ethernet.Interface.{i}. object
- Set DSCP classification criteria, Device.QoS.Classification.{i}.DSCPCheck
- Set pbit marking value, Device.QoS.Classification.{i}.EthernetPriorityMark
- Finally enable the config, set Device.QoS.Classification.{i}.Enable to true

### Example data model configuration

```bash
obuspa -c add Device.QoS.Classification.
obuspa -c set Device.QoS.Classification.1.Interface Device.Ethernet.Interface.3.
obuspa -c set Device.QoS.Classification.1.DSCPCheck 2
obuspa -c set Device.QoS.Classification.1.EthernetPriorityMark 3
obuspa -c set Device.QoS.Classification.1.Enable true
```

### A UCI mapping rule config looks as follows:

```
config classify 'classify_1'
	option enable '1'
	option order '1'
	option ifname 'eth0.3'
	option pcp_mark '3'
	option dscp_filter '2'
```

Note:
- Multiple config can be added this way to create mapping rule for all 64 DSCP values.
- The configured mapping rule can be viewed in the ebtables 'broute' table's 'dscp2pbit' chain
