# VLAN and Pbit Translation

## About VLAN Translation:

VLAN translation, also known as VLAN mapping, is a technique used to associate
different VLAN tags between customer networks and service provider networks.
It involves swapping an incoming VLAN tag with a new VLAN tag.

## Scenario

Imagine a situation where customers and service providers use different VLAN
tags in their networks. The same VLAN tag for a customer may correspond to a
different VLAN tag in the service provider’s network.

For example:
C-VLAN: Customer VLAN (used by the customer network): VLAN 100
S-VLAN: Service provider VLAN (used by the service provider network): VLAN 200

The VLAN translation should happen both ways in order to ensures smooth communication across different VLANs in heterogeneous network environments

## Configuration of VLAN translatinon

VLAN translation can be done on the ingress traffic on the basis of following classification criteria:
- Port name
- Source/destination MAC address
- VLAN ID
- VLAN Pbit value

### Adding mapping rule via TR181:

- Add Device.QoS.Classification. object.
- Set port name, Device.QoS.Classification.{i}.Interface
Note: generally its a reference to Device.Ethernet.Interface.{i}. object
- Set VLAN classification criteria ID, Device.QoS.Classification.{i}.VLANIDCheck
- Set VALN translation ID, Device.QoS.Classification.{i}.X_IOPSYS_EU_VLANIDMark
- Finally enable the config, set Device.QoS.Classification.{i}.Enable to true
- Now, repeat the above step for reverse translation also

### Example data model configuration

```bash
obuspa -c add Device.QoS.Classification.
obuspa -c set Device.QoS.Classification.1.Interface Device.Ethernet.Interface.3.
obuspa -c set Device.QoS.Classification.1.VLANIDCheck 100
obuspa -c set Device.QoS.Classification.1.X_IOPSYS_EU_VLANIDMark 200
obuspa -c set Device.QoS.Classification.1.Enable true

obuspa -c add Device.QoS.Classification.
obuspa -c set Device.QoS.Classification.2.Interface Device.Ethernet.Interface.6.
obuspa -c set Device.QoS.Classification.2.VLANIDCheck 200
obuspa -c set Device.QoS.Classification.2.X_IOPSYS_EU_VLANIDMark 100
obuspa -c set Device.QoS.Classification.2.Enable true

```

### A UCI mapping rule config looks as follows:

```
config classify 'classify_1'
	option enable '1'
	option order '1'
	option ifname 'eth0.3'
	option vid_check '100'
	option vid_mark '200'
	
config classify 'classify_2'
	option enable '1'
	option order '1'
	option ifname 'ae_wan'
	option vid_check '200'
	option vid_mark '100'
```

## About Pbit/802.1p Translation:

802.1p is a quality of service (QoS)/class of service (CoS) method that
operates at the MAC layer (Layer 2). Equipment that supports 802.1p can add and
recognize a value that indicates the priority level of the Ethernet frame.

## Scenario

Suppose we need to remark the Pbit value coming from one of the LAN port.
Pbit 3 should be remarked with Pbit 7
## Configuration of pbit translatinon

### Adding mapping rule via TR181:

- Add Device.QoS.Classification. object.
- Set port name, Device.QoS.Classification.{i}.Interface
Note: generally its a reference to Device.Ethernet.Interface.{i}. object
- Set Pbit classification criteria, Device.QoS.Classification.{i}.EthernetPriorityCheck
- Set Pbit rewrite value, Device.QoS.Classification.{i}.EthernetPriorityMark
- Finally enable the config, set Device.QoS.Classification.{i}.Enable to true

### Example data model configuration

```bash
obuspa -c add Device.QoS.Classification.
obuspa -c set Device.QoS.Classification.1.Interface Device.Ethernet.Interface.3.
obuspa -c set Device.QoS.Classification.1.EthernetPriorityCheck 3
obuspa -c set Device.QoS.Classification.1.EthernetPriorityMark 7
obuspa -c set Device.QoS.Classification.1.Enable true
```

### A UCI mapping rule config looks as follows:

```
config classify 'classify_1'
	option enable '1'
	option order '1'
	option ifname 'eth0.3'
	option pcp_check '3'
	option pcp_mark '7'
```

We can modify any of the params in the UCI file based on our preferance and use case and reload
qos for it to take effect.
