#!/usr/bin/python3

import ubus
import pathlib
import time

TEST_NAME = "Validate Periodic Stats Deamon"

print("Running: " + TEST_NAME)

# Waiting 30 seconds to fill the sampleset parameter value
time.sleep(30)

sock = pathlib.Path('/var/run/ubus/ubus.sock')
if sock.exists():
    assert ubus.connect('/var/run/ubus/ubus.sock')
else:
    assert ubus.connect()

# Check get operation for Device.PeriodicStatistics.SampleSet.1.Parameter.1.Values path succeed
out = ubus.call('bbfdm.periodicstats', 'get', {"path":"Device.PeriodicStatistics.SampleSet.1.Parameter.1.Values"})
print(out)
assert isinstance(out[0]["results"][0], dict), "FAIL: get Device.PeriodicStatistics.SampleSet.1.Parameter.1.Values on usp"

# Check get operation for Device.PeriodicStatistics.SampleSet.1.Parameter.2.Values path succeed
out = ubus.call('bbfdm.periodicstats', 'get', {"path":"Device.PeriodicStatistics.SampleSet.1.Parameter.2.Values"})
print(out)
assert out[0]["results"][0]["data"] == "", "FAIL: get Device.PeriodicStatistics.SampleSet.1.Parameter.2.Values on usp"

# Check get operation for Device.PeriodicStatistics.SampleSet.1.Parameter.3.Values path succeed
out = ubus.call('bbfdm.periodicstats', 'get', {"path":"Device.PeriodicStatistics.SampleSet.1.Parameter.3.Values"})
print(out)
assert isinstance(out[0]["results"][0], dict), "FAIL: get Device.PeriodicStatistics.SampleSet.1.Parameter.3.Values on usp"

# Check get operation for Device.PeriodicStatistics.SampleSet.2.Parameter.1.Values path succeed
out = ubus.call('bbfdm.periodicstats', 'get', {"path":"Device.PeriodicStatistics.SampleSet.2.Parameter.1.Values"})
print(out)
assert isinstance(out[0]["results"][0], dict), "FAIL: get Device.PeriodicStatistics.SampleSet.2.Parameter.1.Values on usp"

# Check get operation for Device.PeriodicStatistics.SampleSet.2.Parameter.2.Values path succeed
out = ubus.call('bbfdm.periodicstats', 'get', {"path":"Device.PeriodicStatistics.SampleSet.2.Parameter.2.Values"})
print(out)
assert isinstance(out[0]["results"][0], dict), "FAIL: get Device.PeriodicStatistics.SampleSet.2.Parameter.2.Values on usp"

print("PASS: " + TEST_NAME)
