#!/bin/bash

echo "Functional Test"
pwd

source ./gitlab-ci/shared.sh

make clean
make func-test -C ./
check_ret $?
ln -s ${PWD}/periodicstatsd /usr/sbin/periodicstatsd

supervisorctl update
sleep 5
supervisorctl status all
exec_cmd ubus wait_for bbfdm
exec_cmd ubus wait_for bbfdm.periodicstats

echo "## Running python based verification of functionalities ##"
echo > ./funl-result.log
num=0
for test in `ls -1 ./test/python/*.py`
do
	num=$(( num + 1 ))
	sleep 1
	$test
	if [ $? -eq 0 ]; then
		echo "ok ${num} - $test" >> ./funl-result.log

	else
		echo "not ok ${num} - $test" >>  ./funl-result.log
	fi
done

echo "1..${num}" >> ./funl-result.log
generate_report python_test ./funl-result.log

supervisorctl stop all
supervisorctl status

#report part
gcovr -r . --xml -o ./funl-test-coverage.xml
gcovr -r .
date +%s > timestamp.log

echo "Checking memory leaks..."
cp /tmp/memory-report.xml ./
check_valgrind_xml "memory-report.xml" "pstats"

echo "Functional Test :: PASS"
