# Periodic Statistics
Periodic Statistics Daemon collects statistics on datamodel objects and expose them using Device.PeriodicStatistics. datamodel object.

## Project Components

Project consists of following components:

- Application written in C programming language
- Datamodel exposed using bbfdm DotSO plugin

## Configuration File

There is no default configuration for periodicstats, it should be added separately.
Below is an example of a basic configuration. Note that in the uci configuration below

```
config globals 'globals'
        option enable '1'

config sampleset 'set_1'
        option fetch_samples '0'
        option enable '1'
        option sample_interval '20'
        option report_sample '7'

config parameter 'param_1_set_1'
        option sample_set 'set_1'
        option enable '1'
        option reference 'Device.Ethernet.Link.1.Stats.BytesReceived'

config sampleset 'set_2'
        option fetch_samples '0'
        option enable '1'
        option sample_interval '10'
        option report_sample '4'

config parameter 'param_1_set_2'
        option sample_set 'set_2'
        option enable '1'
        option reference 'Device.Ethernet.Link.2.Stats.BytesReceived'
```


The device can be configured with mutiple sampleset and parameter sections. The sampleset
object corresponds to the Device.PeriodicStats.SampleSet.{i} object and the parameter section
refers to the Device.PeriodicStats.SampleSet.{i}.Parameter.{i} object.
The parameter section is related to the sampleset object via the sample_set option.
