/*
 * common.h - common code for datamodel libraries
 *
 * Copyright (C) 2024, IOPSYS Software Solutions AB.
 *
 * Author Suvendhu Hansa <suvendhu.hansa@iopsys.eu>
 *
 * See LICENSE file for license related information.
 *
 */

#ifndef __PLUGIN_COMMON_H
#define __PLUGIN_COMMON_H

#include <libbbfdm-api/dmcommon.h>

#define MAX_CMD_LEN 4096
#define MAX_PATH_LEN 1024
#define PROG_CMD_GET "obuspa -c get"
#define PROG_CMD_SET "obuspa -c set"
#define PROG_CMD_ADD "obuspa -c add"
#define PROG_CMD_DEL "obuspa -c del"
#define PROG_CMD_OPERATE "obuspa -c operate"

extern DMOBJ tDevObj[];
extern DMOBJ tUSPAgentObj[];
extern DMLEAF tUSPAgentParams[];
extern DMOBJ tMQTTObj[];
extern DMLEAF tMQTTParams[];
extern DMOBJ tSTOMPObj[];
extern DMLEAF tSTOMPParams[];

struct cmd_result {
	struct list_head list;
	char output[MAX_CMD_LEN];
};

void remove_next_line(char *line);
void remove_whitespaces(char *str);
void exec_cmd(const char *cmd, struct list_head *result_list);
void collect_value(const char *path, struct list_head *result_list, char **value);
void collect_instance(const char *path, struct list_head *result_list, char **value);
void delete_cmd_result(struct list_head *result_list);
void create_json_format(json_object *root, char *path_ob[], int max_ob, int ix, char *val);
void convert_list_to_json(json_object *root, struct list_head *result_list);
int set_succeed(char *param_path, char *value);
int get_instance_number(char *ob_path, char **instance);
int deletion_succeed(char *ob_path);
#endif

