#!/bin/bash

[ -f validate_result.log ] && rm -f validate_result.log

test_num=0

ubus listen bbfdm.AddObj >> ubus_add.txt &
ubus listen bbfdm.DelObj >> ubus_del.txt &

for t in `cat ./test/python/run_test.txt`
do
	echo "">/tmp/output.log
	test_num=$(( test_num + 1 ))
	echo -n "## Running $t ##" >>output_full.txt
	out=$(./test/python/${t})
	if [ "$?" -eq 0 ]; then
		echo "ok ${test_num} - ${t}: ${out}" >> validate_result.log
		echo "Test $t :: PASS"
	else
		echo "not ok ${test_num} - ${t}: ${out}" >> validate_result.log
		echo "Test $t :: FAIL"
	fi
	cat /tmp/output.log >> output_full.txt
	echo -n "## Done $t ##" >>output_full.txt
	sync
done

echo "1..${test_num}" >> validate_result.log
