#!/bin/bash

[ -f validate_result.txt ] && rm -f validate_result.txt

test_num=0
for t in `cat ./test/mqtt/run_test.txt`
do
	test_num=$(( test_num + 1 ))
	echo "## Running $t Test" |tee -a ${t}.txt
	./test/mqtt/${t} >> ${t}.txt
	if [ "$?" -eq 0 ]; then
		echo "ok ${test_num} - PASS: ${t}" >> validate_result.txt
		echo "# Test ${test_num} ${t} - PASS: ${t}" |tee -a ${t}.txt
	else
		echo "not ok ${test_num} - FAIL: ${t}" >> validate_result.txt
		cat /tmp/obuspa-test.log >> ${t}_fail.txt
		echo "######### GREP FILE ############" >> ${t}_fail.txt
		cat /tmp/obuspa-test.grep >> ${t}_fail.txt
		echo "# Test ${test_num} ${t} - FAIL: ${t}" |tee -a ${t}.txt
	fi
done

echo "1..${test_num}" >> validate_result.txt
