#!/bin/bash

echo "Installing dependencies"

source ./gitlab-ci/shared.sh
pwd

install_libwebsockets()
{
	git clone https://github.com/warmcat/libwebsockets.git /opt/libwebsockets
	git -C /opt/libwebsockets v4.3.2
	mkdir -p /opt/libwebsockets/builds
	cd /opt/libwebsockets/builds
	cmake ..
	make
	make install
	cd -
}

# install pre-req for obuspa
exec_cmd apt update
exec_cmd apt install -y libmosquitto-dev mosquitto mosquitto-clients
exec_cmd apt install -y python3-pip
exec_cmd pip3 install pexpect ubus

# Install libwebsockets from source to meet dependency requirements
if [ ! -d "/opt/libwebsockets" ]; then
	install_libwebsockets
fi

# install rabitmq
dpkg -s rabbitmq-server > /dev/null 2>&1
if [ "$?" -ne 0 ]; then
	exec_cmd apt install -y rabbitmq-server

	# configure rabitmq
	/etc/init.d/rabbitmq-server restart
	rabbitmqctl add_user admin password 
	rabbitmqctl set_user_tags admin administrator
	rabbitmqctl set_permissions -p / admin ".*" ".*" ".*"
	rabbitmq-plugins enable rabbitmq_stomp
fi

# install datamodel dependency
install_bbfd

# install obuspa_test_controller
[ -f /tmp/usp.db ] && rm /tmp/usp.db
[ -f /tmp/test_usp.db ] && rm /tmp/test_usp.db

cd /opt/dev/
if [ ! -d obuspa-test-controller ]; then
	exec_cmd git clone https://dev.iopsys.eu/bbf/obuspa-test-controller.git
	cd obuspa-test-controller
	exec_cmd autoreconf --install --force
	exec_cmd ./configure
	exec_cmd make
	exec_cmd cp -f obuspc /usr/local/bin/obuspa_test
fi

exit 0
