# How to provision a new controller

A new controller can be provisioned using firmware default uci or from any of the existing controllers which has access-rights for the setting up a new controller.
To simplify the example, lets use MQTT as a mtp example for rest of the document. 

In both the use-cases, bare minimal configuration required by users are
- Controller with MTP Configuration (Tx Path)
- Agent MTP Configuration (Rx Path)
- Broker (MQTT Client/Stomp Connection) Configuration (not required for WebSocket)


## How to add Broker Configuration

Its advised to do the broker configuration at first, so that it can be referred from other places.
Below is the bare minimal uci configuration for MQTT Client

```bash
config mqtt 'testmqtt'
	option BrokerAddress '127.0.0.1'
	option BrokerPort '1883'
	option TransportProtocol 'TCP/IP'
```

> Note: Uci named sections used in the config, so that it can be easily referred from other configurations

This uci will result into an object instance in 'Device.MQTT.Client.' table, following is the mapping

| Uci Option name | Datamodel Mapping | Remarks  |
| --------------- | ----------------- | -------- |
| BrokerAddress   | Device.MQTT.Client.{i}.BrokerAddress | Check TR181 for more details |
| BrokerPort      | Device.MQTT.Client.{i}.BrokerPort | Check TR181 for more details |
| TransportProtocol | Device.MQTT.Client.{i}.TransportProtocol | Check TR181 for more details |

Similar configuration can be done from datamodel

```bash
root@e74bfe3a4932:~# obuspa -c add Device.MQTT.Client.
Added Device.MQTT.Client.4
root@e74bfe3a4932:~# obuspa -c set Device.MQTT.Client.4.BrokerAddress broker-url-or-ip
Device.MQTT.Client.4.BrokerAddress => broker-url-or-ip
root@e74bfe3a4932:~# obuspa -c set Device.MQTT.Client.4.BrokerPort 1883
Device.MQTT.Client.4.BrokerPort => 1883
root@e74bfe3a4932:~# obuspa -c set Device.MQTT.Client.4.TransportProtocol 'TCP/IP'
Device.MQTT.Client.4.TransportProtocol => TCP/IP
root@e74bfe3a4932:~# obuspa -c set Device.MQTT.Client.4.Enable 1
```

## How to add controller configuration

Below is the bare minimal uci configuration

```bash
config controller 'testcontroller'
	option EndpointID 'proto::interop-usp-controller'
	option Protocol 'MQTT'
	option Topic '/usp/controller'
	option mqtt 'testmqtt'
	option assigned_role_name 'full_access'
```

> Note: Uci named sections used in the config, so that it can be easily referred from other configurations

This uci will result into an object instance in 'Device.LocalAgent.Controller.' table, following is the mapping

| Uci Option name | Datamodel Mapping | Remarks  |
| --------------- | ----------------- | -------- |
| EndpointID      | Device.LocalAgent.Controller.{i}.EndpointID | Defines the usp-controller EndpointID |
| Protocol        | Device.LocalAgent.Controller.{i}.MTP.{i}.Protocol | Defines the protocol used for controller MTP |
| Topic           | Device.LocalAgent.Controller.{i}.MTP.{i}.MQTT.Topic | Defines the topic on which controller listens for incoming messages, datamodel path vary with Protocol definition |
| mqtt            | Device.LocalAgent.Controller.{i}.MTP.{i}.MQTT.Reference | Points to the mqtt client instances, for uci its the section name of mqtt section |
| assigned_role_name | Device.LocalAgent.Controller.{i}.AssignedRole | Define the datamodel access permissions, usually name of json file present in '/etc/users/roles/' path |


Below are the cli commands to do the similar configuration from datamodel pov

```bash
# Get the configured Roles
root@e74bfe3a4932:~# obuspa -c get Device.LocalAgent.ControllerTrust.Role.*.Name
Device.LocalAgent.ControllerTrust.Role.1.Name => Full Access
Device.LocalAgent.ControllerTrust.Role.2.Name => Untrusted
Device.LocalAgent.ControllerTrust.Role.3.Name => admin
Device.LocalAgent.ControllerTrust.Role.4.Name => extender
Device.LocalAgent.ControllerTrust.Role.5.Name => full_access
Device.LocalAgent.ControllerTrust.Role.6.Name => user
root@e74bfe3a4932:~#
# Add new controller with instance
root@e74bfe3a4932:~# obuspa -c add Device.LocalAgent.Controller.
ProcessControllerAdded: WARNING: No MTP instances for Device.LocalAgent.Controller.4
Added Device.LocalAgent.Controller.4
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c add Device.LocalAgent.Controller.4.MTP.
Added Device.LocalAgent.Controller.4.MTP.1
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.EndpointID "self::test-controller"
Device.LocalAgent.Controller.4.EndpointID => self::test-controller
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.AssignedRole Device.LocalAgent.ControllerTrust.Role.3
Device.LocalAgent.Controller.4.AssignedRole => Device.LocalAgent.ControllerTrust.Role.3
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.Protocol MQTT
Device.LocalAgent.Controller.4.MTP.1.Protocol => MQTT
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.MQTT.Topic "/controller-test-topic"
Device.LocalAgent.Controller.4.MTP.1.MQTT.Topic => /controller-test-topic
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.MQTT.Reference "Device.MQTT.Client.4"
Device.LocalAgent.Controller.4.MTP.1.MQTT.Reference => Device.MQTT.Client.4
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.Enable 1
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.Enable 1
```

## How to add agent MTP configuration

Below is the bare minimal uci to add a LocalAgent MTP definition using MQTT

```bash
config mtp 'test_mtp'
	option Protocol 'MQTT'
	option ResponseTopicConfigured '/usp/endpoint'
	option mqtt 'testmqtt'
```

> Note: Uci named sections used in the config, so that it can be easily referred from other configurations

This uci will result into an object instance in 'Device.LocalAgent.Controller.' table, following is the mapping

| Uci Option name | Datamodel Mapping | Remarks  |
| --------------- | ----------------- | -------- |
| Protocol        | Device.LocalAgent.MTP.4.Protocol | Protocol used for Agent MTP |
| ResponseTopicConfigured | Device.LocalAgent.MTP.4.MQTT.ResponseTopicConfigured | MQTT topic used by agent to incoming messages |
| mqtt            | Device.LocalAgent.MTP.4.MQTT.Reference | Uci section name of mqtt section used for this connection |

Similar configuration can be added with:

```bash
root@e74bfe3a4932:~# obuspa -c add Device.LocalAgent.MTP.
Added Device.LocalAgent.MTP.4
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.MTP.4.Protocol MQTT
Device.LocalAgent.MTP.4.Protocol => MQTT
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.MTP.4.MQTT.Reference Device.MQTT.Client.4
Device.LocalAgent.MTP.4.MQTT.Reference => Device.MQTT.Client.4
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.MTP.4.MQTT.ResponseTopicConfigured "/agent-listen-topic"
Device.LocalAgent.MTP.4.MQTT.ResponseTopicConfigured => /agent-listen-topic
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.MTP.4.Enable 1
Device.LocalAgent.MTP.4.Enable => 1
```

## How to configure usp agent to connect using WebSocket

Below is the bare minimal configuration required, for WebSocket usp-agent does not require to define a LocalAgent.MTP. OR an intermediate broker

```
config controller 'web_controller'
        option Enable '1'
        option EndpointID 'self:test-controller'
        option Protocol 'WebSocket'
        option Host 'test-controller.com'
        option Port '443'
        option Path '/usp/controller'
        option EnableEncryption 'true'
	option assigned_role_name=full_access
```

Similar configuration can be added with:
```
root@e74bfe3a4932:~# obuspa -c add Device.LocalAgent.Controller.
Added Device.LocalAgent.Controller.4
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c add Device.LocalAgent.Controller.4.MTP.
Added Device.LocalAgent.Controller.4.MTP.1
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.EndpointID "self::test-controller"
Device.LocalAgent.Controller.4.EndpointID => self::test-controller
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.AssignedRole Device.LocalAgent.ControllerTrust.Role.3
Device.LocalAgent.Controller.4.AssignedRole => Device.LocalAgent.ControllerTrust.Role.3
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.Protocol WebSocket
Device.LocalAgent.Controller.4.MTP.1.Protocol => WebSocket
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.WebSocket.Host test-controller.com
Device.LocalAgent.Controller.4.MTP.1.WebSocket.Host => test-controller.com
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.WebSocket.Port 443
Device.LocalAgent.Controller.4.MTP.1.WebSocket.Port => 443
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.WebSocket.Path "/usp/controller"
Device.LocalAgent.Controller.4.MTP.1.WebSocket.Path => /usp/controller
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.WebSocket.EnableEncryption 1
Device.LocalAgent.Controller.4.MTP.1.WebSocket.EnableEncryption => 1
root@e74bfe3a4932:~#
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.MTP.1.Enable 1
root@e74bfe3a4932:~# obuspa -c set Device.LocalAgent.Controller.4.Enable 1
```

> Note: Above example described the configuration with bare minimal, more uci related configuration available in defined in (UCI API Spec)[https://dev.iopsys.eu/bbf/obuspa/-/blob/devel/docs/api/uci/obuspa.md], to get more details about datamodel parameters please refer to TR181/TR369 specs.
