# Controller discovery via DHCP
DHCP can be employed as a method for Agents to discover Controllers. The DHCPv4 Vendor-Identifying Vendor-Specific Information Option (option code 125) can be used to provide information to Agents about a single Controller. The options that may be provided by DHCP are shown below.

| Option            | Code      |
|-------------------|-----------|
| URL               | 25        |
| Provisioning Code | 26        |
| EndpointID        | 29        |

## Enable DHCP discovery of controller
To enable controller discovery via DHCP the Agent must include `dhcp_discovery` and `interface` option in its UCI as shown below.
```
config obuspa 'global'
        option enabled '1'
        option interface 'wan'
        option dhcp_discovery '1'
```

| Option         | Definition              | default |
|----------------|-------------------------|---------|
| enabled        | enable/disable obuspa   | 1       |
| interface      | listen for DHCP packets | wan     |
| dhcp_discovery | enable DHCP discovery   | 0       |

## Configure DHCP option 125 on server with controller information
OBUSP-Agent as of now only supports MQTT and Websocket controllers information in DHCP discovery. To configure the controller information in DHCP server below specified format need to be followed.

- Controllers information needs to be configured in DHCP option 125, and that must include Broadband Forum Enterprise Number (3561).
- URL must be provided in sub-option 25 and must follow the below format:
    - protocol://FQDN_or_IP:port/topic_or_path. For example:
        - ws://10.2.1.1:80/usp/endpoint
        - wss://controller.dhcp.com:443/usp/endpoint
- Below is a sample of option 125 with all options:
    - 00:00:0D:E9:51:19:1E:77:73:3A:2F:2F:36:2E:30:2E:30:2E:32:3A:38:30:2F:75:73:70:2F:63:6F:6E:74:72:6F:6C:6C:65:72:1A:0C:6F:62:75:73:70:2D:63:6C:69:65:6E:74:1D:21:73:65:6C:66:3A:3A:63:6F:6E:74:72:6F:6C:6C:65:72:2E:6F:62:75:73:70:63:6C:69:74:65:73:74:2E:63:6F:6D

    - 00:00:0D:E9 => BBF Enterprise ID (3561)
    - 51 => total length (81)
    - 19 => URL sub-option (25)
    - 1E => URL length (30)
    - 77:73:3A:2F:2F:36:2E:30:2E:30:2E:32:3A:38:30:2F:75:73:70:2F:63:6F:6E:74:72:6F:6C:6C:65:72 => URL (ws://6.0.0.2:80/usp/controller)
    - 1A => ProvisioningCode sub-option (26)
    - 0C => Provisioning code length (12)
    - 6F:62:75:73:70:2D:63:6C:69:65:6E:74 => Provisioning code (obusp-client)
    - 1D => Endpoint ID sub-option (29)
    - 21 => Endpoint ID length (33)
    - 73:65:6C:66:3A:3A:63:6F:6E:74:72:6F:6C:6C:65:72:2E:6F:62:75:73:70:63:6C:69:74:65:73:74:2E:63:6F:6D => Endpoint ID (self::controller.obuspclitest.com)

## How DHCP discovery works
OBUSP-Agent installs a DHCP hook script (/etc/udhcpc.user.d/udhcpc_obuspa_opt125.user), which gets invoked at the time of a DHCP event occurs on an interface. This script then validates if the event occured on the same interface as it is configured in OBUSPA UCI file. If interface is valid and DHCP discovery is enabled then it extracts option 125 and parses the value of URL, Provisioning Code and Endpoint Id based on enterprise id 3561. This script then configures the newly discovered controller in OBUSPA UCI file.
