#!/bin/bash

function stop_all_services()
{
	supervisorctl stop all
}

function wait_for_obuspa()
{
	local num=0

	echo "wait for bbfdm"
	ubus wait_for bbfdm

	while [ $num -lt 20 ]; do
		obuspa -c get Device.DeviceInfo.SerialNumber > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			echo "Obuspa bootup time = $(( num * 2)) sec"
			return 0;
		fi
		sleep 2
		num=$(( num + 1 ))
	done

	return 255
}

function exec_cmd()
{
	echo "executing $@"
	$@ >/dev/null 2>&1

	if [ $? -ne 0 ]; then
		echo "Failed to execute $@"
		echo "$0 exit status ${ret}"
		stop_all_services
		exit 1
	fi
}

function check_ret()
{
	ret=$?
	if [ $ret -ne 0 ]; then
		stop_all_services
		echo "$0 exit status ${ret}"
		exit $ret
	fi
}

function restart_server()
{
	# install stomp plugin
	if [ "${1}" = "stomp" ]; then
		if [ "${2}" = "enable" ]; then
			rabbitmq-plugins enable rabbitmq_stomp
		else
			rabbitmq-plugins disable rabbitmq_stomp
		fi
	fi
	/etc/init.d/rabbitmq-server restart
	sleep 1
}

function apply_patches()
{
	[ -d "/opt/dev/iopsys" ] && return 0

	exec_cmd git clone -b ${IOPSYS_BRANCH:-devel} https://dev.iopsys.eu/feed/iopsys.git /opt/dev/iopsys
	if [ -d "/opt/dev/iopsys/obuspa/patches/" ]; then
		for f in `ls -1 /opt/dev/iopsys/obuspa/patches/*.patch`; do
			exec_cmd git apply $f
		done
	fi
}

function install_obuspa()
{
	COV_CFLAGS='-g -O0 -fprofile-arcs -ftest-coverage -DOBUSPA_ENABLE_DOWNLOAD_EXT -DOBUSPA_ENABLE_UPLOAD_EXT -DOBUSPA_ENABLE_SESSION_EXT -D_DM_VENDOR_PREFIX=X_IOWRT_EU_ -DOBUSPA_CONTROLLER_MTP_VERIFY -DOBUSPA_MAX_CONTROLLERS_NUM=10'
	COV_LDFLAGS='--coverage'

	# compile obuspa
	if [ -d "./build" ]; then
		rm -rf build
	else
		apply_patches
	fi

	mkdir build
	cd build
	cmake ../ -DCMAKE_VERBOSE_MAKEFILE=ON -DCMAKE_C_FLAGS="$COV_CFLAGS " -DCMAKE_EXE_LINKER_FLAGS="$COV_LDFLAGS"

	# install
	make install
	exec_cmd ln -sf ${PWD}/obuspa /usr/sbin/obuspa
	exec_cmd ln -sf ${PWD}/obuspa ../obuspa
	cd ..
}

function install_bbfd()
{
	[ -d "/opt/dev/bbfdm" ] && return 0

	if [ -n "${BBFDM_BRANCH}" ]; then
		export BRANCH="${BBFDM_BRANCH}"
		exec_cmd git clone -b ${BBFDM_BRANCH} https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	else
		exec_cmd git clone https://dev.iopsys.eu/bbf/bbfdm.git /opt/dev/bbfdm
	fi

	cd /opt/dev/bbfdm
	./gitlab-ci/install-dependencies.sh install
	./gitlab-ci/setup.sh install
}

function install_wifidmd_as_plugin()
{
	[ -d "/opt/dev/wifidmd" ] && return 0

	exec_cmd git clone https://dev.iopsys.eu/bbf/wifidmd.git /opt/dev/wifidmd

	exec_cmd make -C /opt/dev/wifidmd/src/ clean && make -C /opt/dev/wifidmd/src/
	exec_cmd cp -f /opt/dev/wifidmd/src/libwifi.so /usr/share/bbfdm/plugins/
	exec_cmd cp -f /opt/dev/wifidmd/src/libdataelements.so /usr/share/bbfdm/plugins/
}

function install_netmngr_as_plugin()
{
	[ -d "/opt/dev/netmngr" ] && return 0

	exec_cmd git clone https://dev.iopsys.eu/network/netmngr.git /opt/dev/netmngr

	exec_cmd make -C /opt/dev/netmngr/src/ clean && make -C /opt/dev/netmngr/src/
	exec_cmd cp -f /opt/dev/netmngr/src/libnetmngr.so /usr/share/bbfdm/plugins/
	exec_cmd cp -f /opt/dev/netmngr/src/libinterface_stack.so /usr/share/bbfdm/plugins/	
}
