#!/bin/bash

source ./gitlab-ci/shared.sh
date +%s > timestamp.log

# compile and install obuspa
install_obuspa

supervisorctl update
sleep 2

[ -f "/tmp/usp.db" ] && rm -f /tmp/usp.db

supervisorctl restart all
echo "wait for obuspa to start"
wait_for_obuspa
check_ret
supervisorctl status all

echo "## Running obuspa test controller STOMP based tests"
/usr/local/bin/obuspa_test -p -v 4 -f /tmp/test_usp.db -r "/tmp/controller_default_reset.txt" -x "/tmp/ctrl_stomp_example.txt" -l "controller-output.log"
check_ret

supervisorctl stop all
cp /tmp/memory-report.xml memory-report.xml
echo "## Check for memory leak"
grep -q "Leak_DefinitelyLost" memory-report.xml
if [ "$?" -eq 0 ]; then
	echo "Leak detected, check memory-report"
	exit 1
fi

gcovr -r . 2> /dev/null --xml -o ./coverage.xml
#GitLab-CI output
gcovr -r . 2> /dev/null

echo "PASS: All test pass"
