# Concepts and Workflow

OBUSPA in itself has support for below datamodel objects
- Device.LocalAgent.
- Device.Security.
- Device.Time.
- Device.STOMP.
- Device.MQTT.
- Device.BulkData.

For rest of datamodel objects it depends on vendor integrations. Which mostly make the whole USP solution a monolithic block. To make it modular, we did the integration which gets the data over ubus(default rpc bus in openwrt), so that it can easily integrate with any 3rd party data-store. Currently it usages uspd as a data-store which exposes the datamodel object over ubus.

## Theory of operation
OBUSPA operations divided in three blocks {Init, Start, Stop}, vendor integration also follows the same.
- Vendor_Init
	- Reads mandatory objects from uspd, list of parameters available in (uspd_cache_mandatory_data)
	- Gets schema from uspd and register each parameter based on type
	- Registers below vendor hooks
		- Reboot
		- Factory Reset
    	- Transaction start
    	- Transaction commit
    	- Transaction abort
    	- ControllerTrust roles registration

- Vendor_Start
	- Calculate and update cached time for multi-instance objects
	- Loads objects in memory for which caching is disabled
	- Starts a ubus thread
    	- Responsible for getting the data exposed over ubus
    	- Registered for `usp.event` ubus event to signal generated event
    	- Registered for `usp.AddObj` ubus event to signal newly added object instances
    	- Registered for `usp.DelObj` ubus event to signal deleted object instances
	- Setup a socket pair to interact with Ubus thread

- Vendor_Stop
	- Free-up the dynamic allocated data and return


