/*
 *
 * Copyright (C) 2023, IOPSYS Software Solutions AB.
 *
 * Author: vivek.dutta@iopsys.eu
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file vendor_utils.h
 *
 * Header file containing defines controlling the build of USP Agent,
 * which is added by IOPSYS
 *
 */

#ifndef VENDOR_UTILS_H
#define VENDOR_UTILS_H
#include <uci.h>
#include <libubox/blob.h>
#include <libubus.h>
#include <libubox/blobmsg_json.h>
#include "str_vector.h"
#include "usp_log.h"
#include "data_model.h"

#define ROOT_PATH "Device."
#define DM_OBJECT_NAME "bbfdm"
#define DM_RELOAD_HANDLER "bbf.config"
#define DM_SCHEMA_METHOD "schema"
#define DM_INSTANCE_METHOD "instances"
#define DM_FLAG_UNIQUE "Unique"
#define DM_FLAG_SECURE "Secure"

typedef enum {
       DMT_STRING,
       DMT_UNINT,
       DMT_INT,
       DMT_UNLONG,
       DMT_LONG,
       DMT_BOOL,
       DMT_TIME,
       DMT_HEXBIN,
       DMT_BASE64,
       DMT_COMMAND,
       DMT_EVENT,
       DMT_OBJECT,
} dmt_type_t;


int convert_dmt_to_dmtype(dmt_type_t dmt_type);
int get_value_from_uci(const char *path, char *value, size_t max_value_len);
int get_deviceinfo_from_db(const char *param, char *value, size_t max_value_len);
int get_int_value_from_uci(const char *uci_path);

char **blob_array_str_list(struct blob_attr *attr, int *list_nr);
void free_str_list(int num, char **table);

void manual_vec_free(str_vector_t *vec);
void get_parameters_in_kv(struct blob_attr *params, kv_vector_t *kv_out);

struct blob_attr *get_parameters(struct blob_attr *msg, const char *key);
struct blob_attr *get_param_blob(struct blob_attr *msg, const char *key);
dmt_type_t get_dmt_type(char *type);
void blob_add_optinal_params(struct blob_buf *bp);
int get_details_from_blob(struct blob_attr *pattr, char *path, char *data, char *type, char *fault_msg, str_vector_t *flags_sv);
dm_node_t *dm_node_present(char *path);
char *base64_encode(char *in, size_t input_length, size_t *datalen);
int base64_decode(const char *data, size_t *output_length, const char *fname);

#endif // VENDOR_UTILS_H
