#!/bin/bash

source ./gitlab-ci/shared.sh
date +%s > timestamp.log

# compile and install obuspa
install_obuspa

exec_cmd /etc/init.d/rabbitmq-server stop
supervisorctl update
sleep 2
[ -f "/tmp/usp.db" ] && rm -f /tmp/usp.db
supervisorctl restart all
echo "wait for bbfdm"
ubus wait_for bbfdm
supervisorctl status all
supervisorctl stop obuspa
sleep 5

echo "## Running mqtt tests"
./gitlab-ci/run_mqtt_test.sh 
tap-junit --suite "Shell based mqtt mtp verification" --input ./validate_result.txt --output report
check_ret

supervisorctl stop all

gcovr -r . 2> /dev/null --xml -o ./coverage.xml
#GitLab-CI output
gcovr -r . 2> /dev/null

echo "PASS: All test pass"
