#!/bin/bash

source ./gitlab-ci/shared.sh
date +%s > timestamp.log

# compile and install obuspa
install_obuspa

supervisorctl update
sleep 5
[ -f "/tmp/usp.db" ] && rm -f /tmp/usp.db

supervisorctl start all

echo "wait for obuspa to start"
wait_for_obuspa
check_ret
supervisorctl status all

echo "## Running python based tests"
./gitlab-ci/run_python_test.sh 
tap-junit --suite "Python based bug/feature verification" --input ./validate_result.log --output report
check_ret

supervisorctl stop all

cp /tmp/memory-report.xml memory-report.xml

echo "## Check for memory leak"
grep -q "Leak_DefinitelyLost" memory-report.xml
if [ "$?" -eq 0 ]; then
	echo "Leak detected, check memory-report"
	exit 1
fi

gcovr -r . 2> /dev/null --xml -o ./coverage.xml
#GitLab-CI output
gcovr -r . 2> /dev/null

echo "PASS: All test pass"
